/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.android.receiver.ScreenStatusBroadcastReceiver;
import com.huawei.location.lite.common.log.LogLocation;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;

public class LocationUtil {
    private static final String TAG = "LocationUtil";
    private static AtomicBoolean isRegister = new AtomicBoolean(false);
    private static volatile int locatorSDKVersion = 0;

    public static boolean isLocationEnabled(Context context) {
        return LocationUtil.isLocationEnabled(context, true);
    }

    public static boolean isLocationEnabled(Context context, boolean n) {
        int n2;
        if (context == null) {
            LogLocation.e(TAG, "isLocationEnabled Context is null");
            return false;
        }
        try {
            n2 = n;
            n = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            LogLocation.e(TAG, "isLocationEnabled SettingNotFoundException");
            return false;
        }
        LogLocation.i(TAG, "isLocationEnabled locationMode is " + n);
        if (n2 != 0) {
            if (n == 3) {
                int n3 = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"first_open_location_switch", (int)1);
                LogLocation.i(TAG, "isLocationEnabled agreed is " + n3);
                return n3 == 1;
            }
            return false;
        }
        return n == 3;
    }

    public static boolean isScanBleEnabled(Context context) {
        boolean bl = false;
        if (context == null) {
            LogLocation.e(TAG, "isScanBleEnabled Context is null");
            return false;
        }
        int n = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"ble_scan_always_enabled");
        bl = n == 1;
        try {
            LogLocation.i(TAG, "isScanBleEnabled locationMode is " + n);
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            LogLocation.e(TAG, "isScanBleEnabled SettingNotFoundException");
        }
        return bl;
    }

    public static boolean isBlePresent(Context context) {
        if (context == null) {
            LogLocation.e(TAG, "isBlePresent Context is null");
            return false;
        }
        boolean bl = context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
        LogLocation.i(TAG, "isBlePresent isBlePresent is " + bl);
        return bl;
    }

    public static boolean isBlueBoothEnabled(Context context) {
        if (context == null) {
            LogLocation.e(TAG, "isBlueBoothEnabled Context is null");
            return false;
        }
        int n = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"bluetooth_on", (int)-1);
        boolean bl = n == 1;
        LogLocation.i(TAG, "isBlueBoothEnabled locationMode is " + n);
        return bl;
    }

    public static synchronized void registerScreenStatusBroadcast() {
        IntentFilter intentFilter;
        if (isRegister.get()) {
            LogLocation.i(TAG, "registerScreenStatusBroadcast is Register");
            return;
        }
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.intent.action.SCREEN_OFF");
        intentFilter2.addAction("android.intent.action.SCREEN_ON");
        ContextUtil.getContext().registerReceiver((BroadcastReceiver)new ScreenStatusBroadcastReceiver(), intentFilter2);
        isRegister.set(true);
    }

    public static boolean isSystemUser() {
        boolean bl;
        block9: {
            bl = false;
            Object object = Process.myUserHandle();
            Class<?> clazz = object.getClass();
            object = clazz.getDeclaredMethod("isSystem", new Class[0]).invoke(object, new Object[0]);
            if (!(object instanceof Boolean)) break block9;
            try {
                bl = (Boolean)object;
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "unknow exception");
            }
            catch (InvocationTargetException invocationTargetException) {
                LogLocation.e(TAG, "InvocationTargetException");
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLocation.e(TAG, "IllegalAccessException");
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LogLocation.e(TAG, "NoSuchMethodException");
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFilePath(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 24) return context.getFilesDir().getCanonicalPath();
        }
        catch (IOException iOException) {
            LogLocation.e(TAG, "getCanonicalPath is IOException");
            return null;
        }
        return context.createDeviceProtectedStorageContext().getFilesDir().getCanonicalPath();
    }

    public static int getLocatorSDKVersion() {
        return locatorSDKVersion;
    }

    public static void setLocatorSDKVersion(int n) {
        locatorSDKVersion = n;
    }
}

