/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import com.huawei.android.os.BuildEx;
import com.huawei.android.telephony.ServiceStateEx;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.DeviceInfoUtil;
import com.huawei.location.lite.common.util.PermissionUtil;
import com.huawei.location.lite.common.util.ReflectionUtils;

public class NetworkUtil {
    private static final String TAG = "NetworkUtil";
    private static final String NETWORK_NONE = "";
    private static final String NETWORK_WIFI = "wifi";
    private static final String NETWORK_2G = "2G";
    private static final String NETWORK_3G = "3G";
    private static final String NETWORK_4G = "4G";
    private static final String NETWORK_5G = "5G";

    public static String getNetworkState() {
        switch (NetworkUtil.getNetworkType(ContextUtil.getContext())) {
            default: {
                return NETWORK_NONE;
            }
            case 5: {
                return NETWORK_5G;
            }
            case 4: {
                return NETWORK_4G;
            }
            case 3: {
                return NETWORK_3G;
            }
            case 2: {
                return NETWORK_2G;
            }
            case 1: 
        }
        return NETWORK_WIFI;
    }

    public static boolean isCurActiveNetInfoValid(Context context) {
        boolean bl;
        block5: {
            bl = false;
            ConnectivityManager connectivityManager = (ConnectivityManager)NetworkUtil.getSystemService(context, "connectivity");
            if (connectivityManager == null) break block5;
            if (Build.VERSION.SDK_INT < 23) break block5;
            ConnectivityManager connectivityManager2 = connectivityManager;
            connectivityManager = connectivityManager2.getNetworkCapabilities(connectivityManager2.getActiveNetwork());
            if (connectivityManager == null) break block5;
            try {
                bl = connectivityManager.hasCapability(16);
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "isNetValida exception");
            }
        }
        return bl;
    }

    public static int getNetworkType() {
        if (NetworkUtil.getNetworkType(ContextUtil.getContext()) != 1) {
            return 0;
        }
        return 1;
    }

    public static int getNetworkType(Context context) {
        int n;
        block16: {
            block17: {
                block20: {
                    block21: {
                        block18: {
                            int n2;
                            block19: {
                                n = -1;
                                NetworkInfo networkInfo = NetworkUtil.getNetworkInfo(context);
                                if (networkInfo == null) break block16;
                                if (!networkInfo.isConnected()) break block16;
                                int n3 = networkInfo.getType();
                                if (1 == n3 || 13 == n3) break block17;
                                if (DeviceInfoUtil.getDeviceFeature(context) == 8 && 9 == n3) break block17;
                                if (n3 != 0) break block18;
                                n2 = NetworkUtil.getHwNetworkType(context);
                                LogLocation.d(TAG, "getHwNetworkType return is: " + n2);
                                if (n2 != 0) break block19;
                                n2 = networkInfo.getSubtype();
                            }
                            if (n2 != 20) {
                                switch (n2) {
                                    default: {
                                        n = 0;
                                        break;
                                    }
                                    case 13: {
                                        n = 4;
                                        break;
                                    }
                                    case 3: 
                                    case 5: 
                                    case 6: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 12: 
                                    case 14: 
                                    case 15: {
                                        n = 3;
                                        break;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 4: 
                                    case 7: 
                                    case 11: {
                                        n = 2;
                                        break;
                                    }
                                }
                            } else {
                                n = 5;
                            }
                            if (n != 0) break block16;
                            try {
                                if (Build.VERSION.SDK_INT < 25) break block16;
                                if (n2 == 16) break block20;
                                if (n2 == 17) break block21;
                            }
                            catch (Exception exception) {
                                LogLocation.e(TAG, "getNetworkType exception");
                            }
                        }
                        n = 0;
                        break block16;
                    }
                    n = 3;
                    break block16;
                }
                n = 2;
                break block16;
            }
            n = 1;
        }
        return n;
    }

    @SuppressLint(value={"MissingPermission", "NewApi"})
    private static int getHwNetworkType(Context context) {
        int n;
        block7: {
            n = 0;
            if (ReflectionUtils.checkCompatible("com.huawei.android.os.BuildEx$VERSION") && context != null && (context = (TelephonyManager)NetworkUtil.getSystemService(context, "phone")) != null) {
                if (BuildEx.VERSION.EMUI_SDK_INT < 21) break block7;
                context = context.getServiceState();
                if (context == null) break block7;
                try {
                    n = ServiceStateEx.getConfigRadioTechnology((ServiceState)context);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    LogLocation.d(TAG, "NoClassDefFoundError occur in method getHwNetworkType.");
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    LogLocation.d(TAG, "NoSuchMethodError occur in method getHwNetworkType.");
                }
                catch (SecurityException securityException) {
                    LogLocation.d(TAG, "requires permission maybe missing.");
                }
            }
        }
        return n;
    }

    @SuppressLint(value={"MissingPermission"})
    private static NetworkInfo getNetworkInfo(Context context) {
        if (context == null) {
            return null;
        }
        Context context2 = context;
        context = null;
        ConnectivityManager connectivityManager = (ConnectivityManager)NetworkUtil.getSystemService(context2, "connectivity");
        if (connectivityManager != null) {
            try {
                context = connectivityManager.getActiveNetworkInfo();
            }
            catch (RuntimeException runtimeException) {
                LogLocation.d(TAG, "getActiveNetworkInfo failed, exception");
            }
        }
        return context;
    }

    public static boolean isNetworkAvailable(Context context) {
        if (!PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_NETWORK_STATE")) {
            return false;
        }
        return (context = NetworkUtil.getNetworkInfo(context)) != null && context.isConnected();
    }

    private static Object getSystemService(Context object, String string) {
        if (object == null) {
            LogLocation.d(TAG, "context is null");
            return null;
        }
        Context context = object;
        object = null;
        try {
            object = context.getSystemService(string);
        }
        catch (RuntimeException runtimeException) {
            LogLocation.e(TAG, "SystemServer error:", runtimeException);
        }
        return object;
    }

    public static final class NetType {
        public static final int TYPE_NO_NETWORK = -1;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WIFI = 1;
        public static final int TYPE_2G = 2;
        public static final int TYPE_3G = 3;
        public static final int TYPE_4G = 4;
        public static final int TYPE_4G_NSA = 7;
        public static final int TYPE_5G = 5;
        public static final int TYPE_5G_SA = 8;
        public static final int TYPE_MOBILE = 6;
    }
}

