/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.content.PermissionChecker;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.exception.LocationServiceException;
import com.huawei.location.lite.common.exception.LocationStatusCode;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.APKUtil;
import com.huawei.location.lite.common.util.SDKComponentType;
import java.util.Iterator;

public class PermissionUtil {
    private static final String TAG = "PermissionUtil";
    public static final String BACKGROUND_PERMISSION = "android.permission.ACCESS_BACKGROUND_LOCATION";
    public static final String WRITE_EXTERNAL_PERMISSION = "android.permission.WRITE_EXTERNAL_STORAGE";
    public static final String READ_EXTERNAL_PERMISSION = "android.permission.READ_EXTERNAL_STORAGE";
    private static int errorCode = SDKComponentType.getComponentType() == 200 ? 10102 : 10803;

    public static boolean checkSelfPermission(Context context, String string) {
        if (context != null && !TextUtils.isEmpty((CharSequence)string)) {
            if (Build.VERSION.SDK_INT >= 23 ? context.checkSelfPermission(string) == 0 : PermissionChecker.checkSelfPermission((Context)context, (String)string) == 0) {
                return true;
            }
            LogLocation.e(TAG, "do not hasSelfPermission " + string);
            return false;
        }
        LogLocation.e(TAG, "hasSelfPermission failed because of context or permission is null");
        return false;
    }

    public static boolean checkLocationPermission(Context context) {
        if (!PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            LogLocation.i(TAG, "ACCESS_FINE_LOCATION and ACCESS_COARSE_LOCATION is denied");
            return false;
        }
        if (Build.VERSION.SDK_INT <= 28) {
            return true;
        }
        if (PermissionUtil.isAppIsInBackground(context)) {
            LogLocation.i(TAG, "app is in background");
            if (!PermissionUtil.checkSelfPermission(context, BACKGROUND_PERMISSION)) {
                LogLocation.i(TAG, "ACCESS_BACKGROUND_LOCATION is denied");
                return false;
            }
        }
        return true;
    }

    public static boolean isAppIsInBackground(Context context) {
        if (context == null) {
            return false;
        }
        return PermissionUtil.isAppIsInBackground(context.getPackageName());
    }

    public static boolean isAppIsInBackground(String string) {
        boolean bl = true;
        Iterator iterator = ContextUtil.getHMSContext().getSystemService("activity");
        if (!(iterator instanceof ActivityManager)) {
            LogLocation.e(TAG, "managerResult is not a instance of ActivityManager");
            return false;
        }
        iterator = (ActivityManager)iterator;
        if (Build.VERSION.SDK_INT >= 21) {
            if ((iterator = iterator.getRunningAppProcesses()) == null) {
                LogLocation.e(TAG, "runningProcesses is null");
                return false;
            }
            iterator = iterator.iterator();
            block0: while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                if (!PermissionUtil.isImportanceForeground(stringArray.importance)) continue;
                stringArray = stringArray.pkgList;
                int n = stringArray.pkgList.length;
                for (int i = 0; i < n; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    bl = false;
                    continue block0;
                }
            }
            return bl;
        }
        return false;
    }

    private static boolean isImportanceForeground(int n) {
        if (Build.VERSION.SDK_INT > 23) {
            return n <= 125;
        }
        return n <= 100;
    }

    public static boolean hasPermission(Context context, String string, int n, int n2) {
        if (context == null) {
            LogLocation.e(TAG, "hasPermission Context is null");
            return false;
        }
        int n3 = PermissionUtil.checkPermission(context, string, n, n2, null);
        if (n3 == 0) {
            return true;
        }
        if (-1 == n3) {
            LogLocation.e(TAG, "hasPermission, result is " + n3);
            return false;
        }
        LogLocation.e(TAG, "hasPermission, result is " + n3);
        int n4 = errorCode;
        throw new LocationServiceException(n4, LocationStatusCode.getStatusCodeString(n4));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int checkPermission(@NonNull Context context, @NonNull String string, int n, int n2, String object) {
        void var4_7;
        PackageManager packageManager;
        block8: {
            block9: {
                try {
                    packageManager = context.getPackageManager();
                    if (object != null) break block8;
                }
                catch (Exception exception) {
                    LogLocation.e(TAG, "checkPermission LocationServiceException");
                    throw new LocationServiceException(10000, LocationStatusCode.getStatusCodeString(10000));
                }
                String[] stringArray = packageManager.getPackagesForUid(n2);
                if (stringArray == null) break block9;
                if (stringArray.length <= 0) break block9;
                String string2 = stringArray[0];
                break block8;
            }
            LogLocation.i(TAG, "checkPermission get packageName fail ");
            return -1;
        }
        if (APKUtil.getTargetSdkVersion((String)var4_7) < 23) return PermissionChecker.checkPermission((Context)context, (String)string, (int)n, (int)n2, (String)var4_7);
        return packageManager.checkPermission(string, (String)var4_7);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canAccessMockLocation(String string, Context object, Integer n) {
        if (object == null) {
            LogLocation.e(TAG, "canAccessMockLocation Context is null");
            return false;
        }
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                void var2_6;
                Object object2 = object.getSystemService("appops");
                if (var2_6 == null) {
                    LogLocation.e(TAG, "canAccessMockLocation uid is null");
                    return false;
                }
                if (!(object2 instanceof AppOpsManager)) {
                    LogLocation.i(TAG, "canCallerAccessMockLocation ,no AppOpsManager ");
                    return false;
                }
                String string2 = "android:mock_location";
                boolean bl = ((AppOpsManager)object2).noteOp(string2, var2_6.intValue(), string) == 0;
                LogLocation.i(TAG, "canCallerAccessMockLocation ,Build.VERSION.SDK_INT >=23 ,mock is " + bl);
                return bl;
            }
            boolean bl = Settings.Secure.getInt((ContentResolver)object.getContentResolver(), (String)"mock_location", (int)0) != 0;
            LogLocation.i(TAG, "canCallerAccessMockLocation ,Build.VERSION.SDK_INT <23 ,mock is " + bl);
            return bl;
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "canCallerAccessMockLocation ,Exception ", true);
            return false;
        }
        catch (SecurityException securityException) {
            LogLocation.e(TAG, "canCallerAccessMockLocation ,SecurityException ", true);
            return false;
        }
    }

    public static void checkSelfPermissionByException(String string, Context context) {
        if (!PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            LogLocation.e(string, "checkPermissionByException , don't have enough permisson");
            int n = errorCode;
            throw new LocationServiceException(n, LocationStatusCode.getStatusCodeString(n));
        }
        if (Build.VERSION.SDK_INT > 28) {
            LogLocation.i(string, "checkPermissionByException sdk > 28 Q");
            if (!PermissionUtil.checkSelfPermission(context, BACKGROUND_PERMISSION)) {
                LogLocation.e(string, "checkPermissionByException BackgroundPermission is false");
                throw new LocationServiceException(errorCode, LocationStatusCode.getStatusCodeString(errorCode) + "BackgroundPermission is denied.");
            }
        }
    }

    public static boolean checkSelfPermissionByBoolean(String string, Context context) {
        if (!PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            LogLocation.e(string, "checkPermissionByBoolean , don't have enough permisson");
            return false;
        }
        if (Build.VERSION.SDK_INT > 28) {
            LogLocation.i(string, "checkPermissionByBoolean sdk > 28 Q");
            if (!PermissionUtil.checkSelfPermission(context, BACKGROUND_PERMISSION)) {
                LogLocation.e(string, "checkPermissionByBoolean BackgroundPermission is false");
                return false;
            }
        }
        return true;
    }

    public static void checkCPLocationPermissionByException(Context context, String string, int n, int n2, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!PermissionUtil.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION", n, n2) && !PermissionUtil.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION", n, n2)) {
                LogLocation.e(string, "checkCPLocationPermission failed : do not have location permission");
                throw new LocationServiceException(10803, LocationStatusCode.getStatusCodeString(10803) + ":location permission denied.");
            }
            if (Build.VERSION.SDK_INT <= 28) {
                LogLocation.i(string, "sdk < 28 Q");
                return;
            }
            if (PermissionUtil.isAppIsInBackground(string2) && !PermissionUtil.hasPermission(context, BACKGROUND_PERMISSION, n, n2)) {
                LogLocation.e(string, "checkCPLocationPermission failed : do not have background permission");
                throw new LocationServiceException(10803, LocationStatusCode.getStatusCodeString(10803) + ": backgroundPermission is denied.");
            }
            return;
        }
        throw new LocationServiceException(10803, LocationStatusCode.getStatusCodeString(10803) + "packageName is null");
    }

    public static boolean hasLocationPermission(Context context, String string, int n, int n2) {
        block9: {
            block8: {
                block7: {
                    if (PermissionUtil.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION", n, n2)) break block7;
                    if (PermissionUtil.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION", n, n2)) break block7;
                    return false;
                }
                if (Build.VERSION.SDK_INT > 28) break block8;
                return true;
            }
            if (!PermissionUtil.isAppIsInBackground(string)) break block9;
            try {
                if (!PermissionUtil.hasPermission(context, BACKGROUND_PERMISSION, n, n2)) {
                    return false;
                }
            }
            catch (Exception exception) {
                LogLocation.i(TAG, "hasLocationPermission  exception", true);
            }
        }
        return true;
    }

    public static boolean checkCPLocationPermissionByBoolean(Context context, String string, int n, int n2, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (!PermissionUtil.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION", n, n2) && !PermissionUtil.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION", n, n2)) {
            LogLocation.e(string, "checkCPLocationPermission failed : do not have location permission");
            return false;
        }
        if (Build.VERSION.SDK_INT <= 28) {
            return true;
        }
        LogLocation.i(string, "sdk > = 28 Q");
        if (PermissionUtil.isAppIsInBackground(string2) && !PermissionUtil.hasPermission(context, BACKGROUND_PERMISSION, n, n2)) {
            LogLocation.e(string, "checkCPLocationPermission failed : do not have background permission");
            return false;
        }
        return true;
    }
}

