/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.SDKComponentType;
import java.util.HashMap;
import java.util.Map;

public class PreferencesHelper {
    private static final String TAG = "LocationPreferences";
    private static final String DEFAULT_STRING_VALUE = "";
    private static final int DEFAULT_INT_VALUE = -1;
    private static final long DEFAULT_LONG_VALUE = -1L;
    private static final boolean DEFAULT_BOOLEAN_VALUE = false;
    private static final Map<String, ?> DEF_MAP_VALUE = new HashMap();
    private SharedPreferences sharedPreferences;

    public PreferencesHelper(String string) {
        this(string, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PreferencesHelper(String string, int n) {
        Context context = SDKComponentType.getComponentType() == 200 ? ContextUtil.getHMSContext() : ContextUtil.getContext();
        try {
            SharedPreferences sharedPreferences;
            PreferencesHelper preferencesHelper;
            if (Build.VERSION.SDK_INT >= 24) {
                preferencesHelper = this;
                sharedPreferences = context.createDeviceProtectedStorageContext().getSharedPreferences(string, n);
            } else {
                preferencesHelper = this;
                sharedPreferences = context.getSharedPreferences(string, n);
            }
            preferencesHelper.sharedPreferences = sharedPreferences;
            return;
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "init getSharedPreferences fail:" + exception.getMessage());
        }
    }

    public boolean saveString(String string, String string2) {
        block5: {
            PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
            if (preferencesHelper == null) {
                return false;
            }
            preferencesHelper = preferencesHelper.edit();
            if (preferencesHelper == null) break block5;
            PreferencesHelper preferencesHelper2 = preferencesHelper;
            PreferencesHelper preferencesHelper3 = preferencesHelper2;
            preferencesHelper2.putString(string, string2);
            try {
                return preferencesHelper3.commit();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "saveString fail");
            }
        }
        return false;
    }

    public String getString(String string) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return DEFAULT_STRING_VALUE;
        }
        try {
            return preferencesHelper.getString(string, DEFAULT_STRING_VALUE);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getString fail");
            return DEFAULT_STRING_VALUE;
        }
    }

    public boolean saveInt(String string, int n) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return false;
        }
        try {
            return preferencesHelper.edit().putInt(string, n).commit();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "setInt fail");
            return false;
        }
    }

    public int getInt(String string) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return -1;
        }
        try {
            return preferencesHelper.getInt(string, -1);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getInt fail");
            return -1;
        }
    }

    public int getInt(String string, int n) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return n;
        }
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return n;
        }
        try {
            return preferencesHelper.getInt(string, n);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getLong fail", true);
            return n;
        }
    }

    public boolean saveBoolean(String string, boolean bl) {
        block4: {
            PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
            if (preferencesHelper == null) {
                return false;
            }
            preferencesHelper = preferencesHelper.edit();
            if (preferencesHelper == null) break block4;
            try {
                return preferencesHelper.putBoolean(string, bl).commit();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "saveBoolean fail", true);
            }
        }
        return false;
    }

    public boolean getBoolean(String string) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return false;
        }
        try {
            return preferencesHelper.getBoolean(string, false);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getBoolean fail");
            return false;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return bl;
        }
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return bl;
        }
        try {
            return preferencesHelper.getBoolean(string, bl);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getBoolean fail", true);
            return bl;
        }
    }

    public boolean saveLong(String string, long l) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return false;
        }
        try {
            return preferencesHelper.edit().putLong(string, l).commit();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "saveLong fail");
            return false;
        }
    }

    public long getLong(String string) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return -1L;
        }
        try {
            return preferencesHelper.getLong(string, -1L);
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getLong fail");
            return -1L;
        }
    }

    public boolean removeString(String string) {
        block5: {
            if (preferencesHelper.sharedPreferences == null) {
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences.edit();
            if (preferencesHelper == null) break block5;
            try {
                return preferencesHelper.remove(string).commit();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "removeString fail", true);
            }
        }
        return false;
    }

    public boolean remove(String string) {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return false;
        }
        try {
            return preferencesHelper.edit().remove(string).commit();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "remove fail");
            return false;
        }
    }

    public Map<String, ?> getAll() {
        PreferencesHelper preferencesHelper = preferencesHelper.sharedPreferences;
        if (preferencesHelper == null) {
            return DEF_MAP_VALUE;
        }
        try {
            return preferencesHelper.getAll();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getAll fail", true);
            return DEF_MAP_VALUE;
        }
    }
}

