/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.os.Build;
import android.text.TextUtils;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.SystemPropertiesUtil;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ROMUtil {
    public static final int ROM_TYPE_NOT_HUAWEI = -1;
    public static final int ROM_TYPE_EMUI = 1;
    public static final int ROM_TYPE_MAGIC_UI = 2;
    public static final int ROM_TYPE_HARMONY = 3;
    public static final int ROM_TYPE_USE_BRAND_CUST = 4;
    public static final int ROM_TYPE_HARMONY_OEM = 5;
    public static final String MANUFACTURER_HUAWEI = "HUAWEI";
    public static final String MANUFACTURER_HONOR = "HONOR";
    private static final String BUILD_VERSION_CLASS_HONOR = "com.hihonor.android.os.Build$VERSION";
    private static final String TAG = "ROMUtil";
    private static AtomicBoolean romRegionIsCn;
    private static AtomicBoolean romHmsGms;
    private static AtomicInteger romType;
    private static AtomicInteger emuiVersionCode;
    private static AtomicBoolean isHuaweiDevice;

    public static boolean isAbroadHWPlatformRom() {
        return ROMUtil.isHuaweiPlatformDevice() && !ROMUtil.isChineseRom();
    }

    public static boolean isChineseRom() {
        AtomicBoolean atomicBoolean = romRegionIsCn;
        if (atomicBoolean != null) {
            return atomicBoolean.get();
        }
        boolean bl = "CN".equalsIgnoreCase(SystemPropertiesUtil.getProRegion());
        LogLocation.d(TAG, "isChineseRom is " + bl);
        romRegionIsCn = new AtomicBoolean(bl);
        return romRegionIsCn.get();
    }

    public static boolean isGmsRom() {
        Object object = romHmsGms;
        if (object != null) {
            ((AtomicBoolean)object).get();
        }
        object = SystemPropertiesUtil.get("ro.com.google.gmsversion", "");
        LogLocation.d(TAG, "isGmsVersion is " + (String)object);
        romHmsGms = new AtomicBoolean(TextUtils.isEmpty((CharSequence)object) ^ true);
        return romHmsGms.get();
    }

    public static boolean isHuaweiPlatformDevice() {
        if (isHuaweiDevice != null) {
            LogLocation.d(TAG, "is huawei device:" + isHuaweiDevice.get());
            return isHuaweiDevice.get();
        }
        boolean bl = ROMUtil.getHuaweiPlatformROMType() != -1;
        LogLocation.d(TAG, "is huawei device:" + bl);
        isHuaweiDevice = new AtomicBoolean(bl);
        return isHuaweiDevice.get();
    }

    private static boolean isUseBrandCust() {
        return TextUtils.equals((CharSequence)SystemPropertiesUtil.get("hw_sc.product.useBrandCust", ""), (CharSequence)"true");
    }

    public static int getEmuiVersionCode() {
        AtomicInteger atomicInteger = emuiVersionCode;
        if (atomicInteger != null) {
            return atomicInteger.get();
        }
        int n = ROMUtil.getVersionCodeFromBuild(0);
        if (n <= 0) {
            try {
                n = Integer.parseInt(SystemPropertiesUtil.get("ro.build.hw_emui_api_level", "0"));
            }
            catch (NumberFormatException numberFormatException) {
                LogLocation.e(TAG, "NumberFormatException: get hw_emui_api_level failed");
            }
        }
        LogLocation.d(TAG, "EMUI_VERSION_CODE: " + n);
        emuiVersionCode = new AtomicInteger(n);
        return emuiVersionCode.get();
    }

    private static int getVersionCodeFromBuild(int n) {
        block10: {
            Object object = Class.forName("com.huawei.android.os.BuildEx$VERSION");
            Field field = ((Class)object).getField("EMUI_SDK_INT");
            AccessibleObject.setAccessible(new Field[]{field}, true);
            object = field.get(object);
            if (object == null) break block10;
            if (!(object instanceof Integer)) break block10;
            try {
                n = (Integer)object;
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "getVersionCodeFromBuild unknown exception");
            }
            catch (ClassCastException classCastException) {
                LogLocation.e(TAG, "getVersionCodeFromBuild ClassCastException");
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLocation.e(TAG, "getVersionCodeFromBuild IllegalAccessException");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LogLocation.e(TAG, "getVersionCodeFromBuild NoSuchFieldException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                n = ROMUtil.getVersionCodeFromHonorBuild(n);
                LogLocation.e(TAG, "getVersionCodeFromBuild ClassNotFoundException");
            }
        }
        return n;
    }

    private static int getVersionCodeFromHonorBuild(int n) {
        block10: {
            Object object = Class.forName(BUILD_VERSION_CLASS_HONOR);
            Field field = ((Class)object).getField("EMUI_SDK_INT");
            AccessibleObject.setAccessible(new Field[]{field}, true);
            object = field.get(object);
            if (object == null) break block10;
            if (!(object instanceof Integer)) break block10;
            try {
                n = (Integer)object;
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "getVersionCodeFromHonorBuild unknown exception");
            }
            catch (ClassCastException classCastException) {
                LogLocation.e(TAG, "getVersionCodeFromHonorBuild ClassCastException");
            }
            catch (IllegalAccessException illegalAccessException) {
                LogLocation.e(TAG, "getVersionCodeFromHonorBuild IllegalAccessException");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LogLocation.e(TAG, "getVersionCodeFromHonorBuild NoSuchFieldException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                LogLocation.e(TAG, "getVersionCodeFromHonorBuild ClassNotFoundException");
            }
        }
        return n;
    }

    public static String getEmuiVerName() {
        String string = SystemPropertiesUtil.getEMUIVersion();
        LogLocation.d(TAG, "Emui version name: " + string);
        return string;
    }

    public static boolean isMagic6OrAbove() {
        return ROMUtil.getHuaweiPlatformROMType() == 2 && ROMUtil.getEmuiVersionCode() >= 32;
    }

    public static boolean isHarmony() {
        int n = ROMUtil.getHuaweiPlatformROMType();
        return n == 3 || n == 4 || n == 5;
    }

    /*
     * Unable to fully structure code
     */
    public static int getHuaweiPlatformROMType() {
        var0 = ROMUtil.romType;
        if (var0 != null) {
            return var0.get();
        }
        var0 = Build.MANUFACTURER;
        var1_1 = ROMUtil.getEmuiVersionCode();
        var2_2 = -1;
        var0.hashCode();
        if (!var0.equals("HONOR")) {
            if (!var0.equals("HUAWEI")) {
                if (var1_1 >= 27) {
                    var2_2 = ROMUtil.isUseBrandCust() ? 4 : 5;
                }
            } else if (var1_1 >= 27) {
                var2_2 = 3;
            } else if (var1_1 > 0) {
                while (true) {
                    var2_2 = 1;
                    break;
                }
            }
        } else {
            if (var1_1 > 0 && var1_1 <= 25) ** continue;
            if (var1_1 == 26 || var1_1 >= 29) {
                var2_2 = 2;
            }
        }
        LogLocation.d("ROMUtil", "Rom type is " + var2_2);
        ROMUtil.romType = new AtomicInteger(var2_2);
        return ROMUtil.romType.get();
    }
}

