/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.text.TextUtils;
import com.huawei.location.lite.common.log.LogLocation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static final String TAG = "ReflectionUtils";
    private static final String SPACE = " ";

    private ReflectionUtils() {
    }

    public static Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        LogLocation.e(TAG, "className not found:" + string);
        return null;
    }

    public static boolean isSupportClass(String string) {
        return ReflectionUtils.getClass(string) != null;
    }

    public static boolean isSupportMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        return ReflectionUtils.getMethod(clazz, string, classArray) != null;
    }

    public static Field getField(Class<?> clazz, String string) {
        if (clazz != null && !TextUtils.isEmpty((CharSequence)string)) {
            try {
                return clazz.getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LogLocation.e(TAG, "getField NoSuchFieldException");
                return null;
            }
        }
        return null;
    }

    public static Field getDeclaredField(Class<?> clazz, String string) {
        if (clazz != null && !TextUtils.isEmpty((CharSequence)string)) {
            try {
                return clazz.getDeclaredField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                LogLocation.e(TAG, "getField NoSuchFieldException");
                return null;
            }
        }
        return null;
    }

    public static Object invoke(Object object, Method method, Object ... objectArray) {
        if (method != null) {
            try {
                return method.invoke(object, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            LogLocation.e(TAG, "invoke Exception");
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static Object invoke(Object object, Method method) {
        if (method != null) {
            try {
                return method.invoke(object, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
            LogLocation.e(TAG, "invoke Exception");
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    public static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        if (clazz != null && !TextUtils.isEmpty((CharSequence)string)) {
            try {
                return clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                LogLocation.e(TAG, "getMethod NoSuchMethodException");
                return null;
            }
        }
        return null;
    }

    public static boolean checkCompatible(String string) {
        try {
            ReflectionUtils.tryLoadClass(string);
            return true;
        }
        catch (Exception exception) {
            LogLocation.w(TAG, string + "ClassNotFoundException");
            return false;
        }
    }

    private static void tryLoadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = ReflectionUtils.class.getClassLoader();
        if (classLoader != null) {
            classLoader.loadClass(string);
            return;
        }
        throw new ClassNotFoundException("not found classloader");
    }
}

