/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.text.TextUtils;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String TAG = "LocationStringUtil";
    private static final Pattern INT_PATTERN = Pattern.compile("\\d+");
    private static final Pattern VALID_PATTERN = Pattern.compile("^[.0-9a-zA-Z_-]{1,}$");

    public static String replaceValue(String string, String string2, String string3) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            return string.replaceAll("(?i)" + string2, string3);
        }
        return string;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static String getDefaultValue(String string, String string2) {
        if (!StringUtil.isEmpty(string)) {
            string2 = string;
        }
        return string2;
    }

    public static boolean isInt(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return INT_PATTERN.matcher(string).matches();
    }

    public static boolean isValid(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return VALID_PATTERN.matcher(string).matches();
    }

    public static boolean isValid(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return StringUtil.isValid(string);
        }
        return Pattern.compile(string2).matcher(string).matches();
    }

    public static boolean isAnyBlank(List<String> object) {
        if (object != null && !object.isEmpty()) {
            object = object.iterator();
            while (object.hasNext()) {
                if (!StringUtil.isEmpty((String)object.next())) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

