/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.os.Build;
import android.text.TextUtils;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;

public class SystemPropertiesUtil {
    private static final String TAG = "SystemPropertiesUtil";
    private static final String CLASS_NAME = "android.os.SystemProperties";
    private static final String NULL_FLAG = "NULL";
    private static Map<String, String> honorProMap;
    private static volatile String characteristics;
    private static volatile String vendor;
    private static volatile String manufacturer;
    private static volatile String emuiVerion;
    private static volatile String androidVersion;
    private static volatile String hardware;
    private static volatile String fullVersionId;
    private static volatile String region;
    private static volatile String platform;
    private static volatile String model;

    private static void initHonorProMapMap() {
        honorProMap = new HashMap<String, String>(4);
        honorProMap.put("ro.hw.country", "msc.sys.country");
        honorProMap.put("ro.build.hw_emui_api_level", "ro.build.magic_api_level");
        honorProMap.put("ro.build.version.emui", "ro.build.version.magic");
        honorProMap.put("ro.config.hw_nlp", "msc.config.nlp");
    }

    private static synchronized String getHonorProKey(String string) {
        if (honorProMap == null) {
            SystemPropertiesUtil.initHonorProMapMap();
        }
        return honorProMap.get(string);
    }

    public static String get(String string, String string2) {
        Object object;
        block8: {
            Class<?> clazz = ReflectionUtils.getClass(CLASS_NAME);
            Class[] classArray = new Class[2];
            classArray[0] = String.class;
            classArray[1] = String.class;
            object = ReflectionUtils.invoke(null, ReflectionUtils.getMethod(clazz, "get", classArray), string, string2);
            if (!(object instanceof String)) break block8;
            try {
                object = (String)object;
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "get SystemProperties Exception");
                object = string2;
            }
        }
        object = string2;
        if (TextUtils.equals((CharSequence)object, (CharSequence)string2) && !TextUtils.isEmpty((CharSequence)(string = SystemPropertiesUtil.getHonorProKey(string)))) {
            return SystemPropertiesUtil.get(string, string2);
        }
        return object;
    }

    public static String getProperty(String string, String string2) {
        return SystemPropertiesUtil.get(string, string2);
    }

    public static String getVersion() {
        if (!TextUtils.isEmpty((CharSequence)fullVersionId)) {
            return fullVersionId;
        }
        int n = 3;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        stringArray[0] = SystemPropertiesUtil.get("ro.build.realversion.id", NULL_FLAG);
        stringArray[1] = SystemPropertiesUtil.get("ro.build.cust.id", NULL_FLAG);
        stringArray[2] = SystemPropertiesUtil.get("ro.build.display.id", NULL_FLAG);
        fullVersionId = Build.DISPLAY;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            if (NULL_FLAG.equals(string)) continue;
            fullVersionId = string;
            break;
        }
        return fullVersionId;
    }

    public static String getEMUIVersion() {
        if (!TextUtils.isEmpty((CharSequence)emuiVerion)) {
            return emuiVerion;
        }
        emuiVerion = SystemPropertiesUtil.get("ro.build.version.emui", NULL_FLAG);
        return emuiVerion;
    }

    public static String getAndroidVersion() {
        if (!TextUtils.isEmpty((CharSequence)androidVersion)) {
            return androidVersion;
        }
        androidVersion = SystemPropertiesUtil.get("ro.build.version.release", NULL_FLAG);
        return androidVersion;
    }

    public static String getHardWare() {
        if (!TextUtils.isEmpty((CharSequence)hardware)) {
            return hardware;
        }
        hardware = SystemPropertiesUtil.get("ro.boot.hardware", "UNDEFINED");
        return hardware;
    }

    public static String getCharacter() {
        if (!TextUtils.isEmpty((CharSequence)characteristics)) {
            return characteristics;
        }
        characteristics = SystemPropertiesUtil.get("ro.build.characteristics", "");
        return characteristics;
    }

    public static String getEmulator() {
        if (!TextUtils.isEmpty((CharSequence)vendor)) {
            return vendor;
        }
        vendor = SystemPropertiesUtil.get("ro.kernel.qemu", "");
        return vendor;
    }

    public static String getVendor() {
        if (!TextUtils.isEmpty((CharSequence)manufacturer)) {
            return manufacturer;
        }
        manufacturer = SystemPropertiesUtil.get("ro.product.manufacturer", "");
        return manufacturer;
    }

    public static String getProRegion() {
        if (!TextUtils.isEmpty((CharSequence)region)) {
            return region;
        }
        region = SystemPropertiesUtil.get("ro.product.locale.region", "");
        return region;
    }

    public static String getPlatform() {
        if (!TextUtils.isEmpty((CharSequence)platform)) {
            return platform;
        }
        platform = SystemPropertiesUtil.get("ro.board.platform", "");
        return platform;
    }

    public static String getModel() {
        if (!TextUtils.isEmpty((CharSequence)model)) {
            return model;
        }
        model = SystemPropertiesUtil.get("ro.product.model", "");
        return model;
    }
}

