/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.DeviceInfoUtil;
import com.huawei.location.lite.common.util.SystemPropertiesUtil;
import java.util.Locale;

public class TelephonyUtil {
    public static final String DEFAULT_NO_COUNTRY = "UNKNOWN";
    public static final String CN_MCC_CODE = "460";
    private static final String TAG = "TelephonyUtil";
    private static final String SPECIAL_COUNTRYCODE_EU = "eu";
    private static final String SPECIAL_COUNTRYCODE_LA = "la";
    private static final String SPECIAL_COUNTRYCODE_CN = "cn";

    private TelephonyUtil() {
    }

    @TargetApi(value=17)
    public static boolean isAirplaneModeOn() {
        return Settings.Global.getInt((ContentResolver)ContextUtil.getContext().getApplicationContext().getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    public static String getNetworkCountryCode() {
        block9: {
            block10: {
                Object object;
                block8: {
                    block7: {
                        try {
                            if (!TelephonyUtil.hasNoSimCard()) break block7;
                            return "";
                        }
                        catch (Exception exception) {
                            LogLocation.e(TAG, "getNetworkCountryCode exception", true);
                            return "";
                        }
                    }
                    object = ContextUtil.getHMSContext().getApplicationContext().getSystemService("phone");
                    if (object != null) break block8;
                    return "";
                }
                if (!(object instanceof TelephonyManager)) break block9;
                object = (TelephonyManager)object;
                if (object.getPhoneType() == 2) break block10;
                return TelephonyUtil.checkedCountryCode(object.getNetworkCountryIso());
            }
            return "";
        }
        return "";
    }

    @TargetApi(value=17)
    public static boolean isAirplaneModeOn(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            LogLocation.d(TAG, "current version JELLY_BEAN_MR1");
            return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
        }
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    public static boolean isSimNetworkRoaming() {
        block4: {
            Object object = ContextUtil.getHMSContext().getApplicationContext().getSystemService("phone");
            if (!(object instanceof TelephonyManager)) break block4;
            try {
                return ((TelephonyManager)object).isNetworkRoaming();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "isSimRoaming exception", true);
            }
        }
        return false;
    }

    public static String getSimCountryCode() {
        block7: {
            String string;
            block8: {
                Object object = ContextUtil.getHMSContext().getApplicationContext().getSystemService("phone");
                if (!(object instanceof TelephonyManager)) break block7;
                object = (TelephonyManager)object;
                string = null;
                if (object.getSimState() != 5) break block8;
                string = object.getSimCountryIso();
            }
            try {
                return TelephonyUtil.checkedCountryCode(string);
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "getSimCountryCode exception", true);
            }
        }
        return "";
    }

    public static String getVendorCountryCode() {
        block5: {
            String string;
            try {
                string = SystemPropertiesUtil.get("ro.hw.country", DEFAULT_NO_COUNTRY);
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "getVendorCountryCode exception", true);
                return "";
            }
            if (SPECIAL_COUNTRYCODE_EU.equalsIgnoreCase(string)) break block5;
            if (SPECIAL_COUNTRYCODE_LA.equalsIgnoreCase(string)) break block5;
            return TelephonyUtil.checkedCountryCode(string);
        }
        return "";
    }

    public static String getDeviceLocaleCountryCode() {
        try {
            return TelephonyUtil.checkedCountryCode(Locale.getDefault().getCountry());
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "getLocalCountryCode exception", true);
            return "";
        }
    }

    public static String getRegionLocalCountryCode() {
        String string = SystemPropertiesUtil.getProRegion();
        if (!SPECIAL_COUNTRYCODE_CN.equalsIgnoreCase(string)) {
            LogLocation.w(TAG, "countryCode from system language is not reliable.");
            return null;
        }
        return string;
    }

    private static String checkedCountryCode(String string) {
        if (!TextUtils.isEmpty((CharSequence)string) && string.length() == 2) {
            return string;
        }
        return "";
    }

    public static boolean hasNoSimCard() {
        Object object = ContextUtil.getHMSContext().getApplicationContext().getSystemService("phone");
        boolean bl = false;
        if (object instanceof TelephonyManager) {
            int n = ((TelephonyManager)object).getSimState();
            switch (n) {
                default: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    bl = true;
                }
            }
            LogLocation.d(TAG, "simState:" + n);
        }
        return bl;
    }

    public static boolean checkWifiIsEnable(@NonNull Context object) {
        block4: {
            object = object.getApplicationContext().getSystemService("wifi");
            if (!(object instanceof WifiManager)) break block4;
            try {
                return ((WifiManager)object).isWifiEnabled();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "checkWifiIsEnable exception");
            }
        }
        return false;
    }

    public static boolean checkWLANScan(@NonNull Context object) {
        block4: {
            object = object.getApplicationContext().getSystemService("wifi");
            if (!(object instanceof WifiManager)) break block4;
            try {
                return ((WifiManager)object).isScanAlwaysAvailable();
            }
            catch (Exception exception) {
                LogLocation.e(TAG, "isWLANScan error, system exception");
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMcc() {
        try {
            Object object;
            if (TelephonyUtil.isAirplaneModeOn()) {
                LogLocation.d(TAG, "airplaneMode on, no mcc");
                return TelephonyUtil.getCarMcc();
            }
            Object object2 = ContextUtil.getHMSContext().getApplicationContext().getSystemService("phone");
            if (object2 == null) {
                LogLocation.d(TAG, "systemService is null");
                return TelephonyUtil.getCarMcc();
            }
            TelephonyManager telephonyManager = null;
            if (object2 instanceof TelephonyManager) {
                telephonyManager = (TelephonyManager)object2;
            }
            if (telephonyManager == null) {
                LogLocation.d(TAG, "no TelephonyManager");
                return TelephonyUtil.getCarMcc();
            }
            object2 = null;
            if (telephonyManager.getPhoneType() == 2) {
                if (telephonyManager.getSimState() == 5 && !telephonyManager.isNetworkRoaming()) {
                    object = telephonyManager.getSimOperator();
                }
            } else {
                object = object2 = telephonyManager.getNetworkOperator();
            }
            if (object2 != null && ((String)object2).length() >= 3) {
                return ((String)object2).substring(0, 3);
            }
            return TelephonyUtil.getCarMcc();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getCarMcc() {
        if (DeviceInfoUtil.getDeviceFeature(ContextUtil.getContext()) != 8) {
            return "";
        }
        String string = LocationNlpGrsHelper.getLocationIPAddress();
        if (TextUtils.isEmpty((CharSequence)string)) {
            LogLocation.w(TAG, "getCarMcc--getLocationIPAddress--host is empty");
            return "";
        }
        if (string.contains(SPECIAL_COUNTRYCODE_CN)) {
            return CN_MCC_CODE;
        }
        LogLocation.w(TAG, "getCarMcc--host is empty");
        return "";
    }
}

