/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.coordinateconverter;

import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.coordinateconverter.CoordinateTransform;
import com.huawei.location.lite.common.util.coordinateconverter.LatLon;

public class CoordinateUtil {
    private static final String TAG = "CoordinateUtil";
    private static final int GPS84TO02 = 1;
    private static final int GCJ02TO84 = 0;
    private static final int MAX_LON = 180;
    private static final int MIN_LON = -180;
    private static final int MAX_LAT = 90;
    private static final int MIN_LAT = -90;

    public static LatLon convertCoord(double d, double d3, int n) {
        if (n == 1) {
            return CoordinateUtil.gps84ToGcj02(d, d3);
        }
        LogLocation.e(TAG, "coordType is not 84");
        return null;
    }

    private static boolean isValidCoordinates(double d, double d3) {
        return !(d < -90.0 || d > 90.0 || d3 < -180.0 || d3 > 180.0);
    }

    private static LatLon gps84ToGcj02(double d, double d3) {
        return CoordinateUtil.transform(d, d3, 1);
    }

    private static LatLon transform(double d, double d3, int n) {
        if (n == 1 && !CoordinateUtil.isValidCoordinates(d, d3)) {
            LogLocation.e(TAG, "transform latLon is not Valid Coordinates");
            return null;
        }
        return CoordinateTransform.convertCoord(d, d3, 1);
    }
}

