/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.country;

import android.text.TextUtils;
import com.huawei.hms.framework.network.grs.GrsApp;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.TelephonyUtil;
import com.huawei.location.lite.common.util.country.CountryConfig;

public class CountryCodeUtil {
    private static final String TAG = "CountryCodeUtil";
    public static final String UNKNOWN = "UNKNOWN";
    private static final String COUNTRY_CODE_EU = "EU";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCountryCode() {
        String string = TelephonyUtil.getNetworkCountryCode();
        if (CountryCodeUtil.isCodeValidate(string)) {
            LogLocation.d(TAG, "getCountryCode get country code from NETWORK_ISO_COUNTRY");
            return string;
        }
        string = TelephonyUtil.getVendorCountryCode();
        if (CountryCodeUtil.isCodeValidate(string)) {
            LogLocation.d(TAG, "getCountryCode get country code from VENDOR_COUNTRY");
            return string;
        }
        string = TelephonyUtil.getSimCountryCode();
        if (CountryCodeUtil.isCodeValidate(string)) {
            LogLocation.d(TAG, "getCountryCode get country code from SIM_COUNTRY");
            return string;
        }
        string = TelephonyUtil.getRegionLocalCountryCode();
        if (CountryCodeUtil.isCodeValidate(string)) {
            LogLocation.d(TAG, "getCountryCode get country code from LOCALE_INFO");
            return string;
        }
        string = TelephonyUtil.getDeviceLocaleCountryCode();
        try {
            if (CountryCodeUtil.isCodeValidate(string)) {
                LogLocation.d(TAG, "getCountryCode get country code from device locale");
                return string;
            }
            LogLocation.w(TAG, "fail to get grs countryCode");
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "get CountryCode error");
        }
        LogLocation.d(TAG, "get countryCode is null");
        return UNKNOWN;
    }

    public static boolean isCodeValidate(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && !UNKNOWN.equals(string);
    }

    public static String getLocationCountryCode() {
        if (TelephonyUtil.isAirplaneModeOn()) {
            LogLocation.d(TAG, "airplane Mode is on");
            return UNKNOWN;
        }
        String string = TelephonyUtil.getNetworkCountryCode();
        if (TextUtils.isEmpty((CharSequence)string) && !TelephonyUtil.isSimNetworkRoaming()) {
            string = TelephonyUtil.getSimCountryCode();
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = UNKNOWN;
            LogLocation.d(TAG, "get countryCode is UNKNOWN");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getPrivacyCountryCode() {
        String string;
        try {
            string = TelephonyUtil.getNetworkCountryCode();
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "get CountryCode error");
            LogLocation.d(TAG, "get countryCode is null");
            return COUNTRY_CODE_EU;
        }
        if (!CountryCodeUtil.isCodeValidate(string)) return CountryCodeUtil.getGrsIssueCountryCode();
        LogLocation.d(TAG, "getCountryCode get country code from NETWORK_ISO_COUNTRY");
        return string;
    }

    public static String getGrsIssueCountryCode() {
        String string = GrsApp.getInstance().getIssueCountryCode(ContextUtil.getContext());
        if (TextUtils.equals((CharSequence)UNKNOWN, (CharSequence)string)) {
            string = COUNTRY_CODE_EU;
        }
        return string;
    }

    public static String getNetWorkDr() {
        String string = TelephonyUtil.getNetworkCountryCode();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return CountryConfig.country2DR(string);
    }
}

