/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.country;

import com.huawei.location.lite.common.util.country.CountryCodeUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class CountryConfig {
    private static final String TAG = "CountryConfig";
    public static final String DR1_NAME = "DR1";
    public static final String DR2_NAME = "DR2";
    public static final String DR3_NAME = "DR3";
    public static final String DR4_NAME = "DR4";
    public static final String DEFAULT_DR_NAME = "DR3";
    private static final List<String> DR1 = Arrays.asList("CN");
    private static final List<String> DR2 = Arrays.asList("AE", "AF", "AG", "AI", "AM", "AO", "AQ", "AR", "AS", "AW", "AZ", "BB", "BD", "BF", "BH", "BI", "BJ", "BL", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CC", "CD", "CF", "CG", "CI", "CK", "CL", "CM", "CO", "CR", "CU", "CV", "CX", "DJ", "DM", "DO", "DZ", "EC", "EG", "EH", "ER", "ET", "FJ", "FK", "FM", "GA", "GD", "GE", "GF", "GH", "GM", "GN", "GP", "GQ", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HT", "ID", "IN", "IO", "IQ", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LK", "LR", "LS", "LY", "MA", "MG", "MH", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NP", "NR", "NU", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PN", "PR", "PS", "PW", "PY", "QA", "RE", "RW", "SA", "SB", "SC", "SD", "SG", "SH", "SL", "SN", "SO", "SR", "SS", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TT", "TV", "TW", "TZ", "UG", "UY", "UZ", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "ZA", "ZM", "ZW");
    private static final List<String> DR3 = Arrays.asList("AD", "AL", "AN", "AT", "AU", "AX", "BA", "BE", "BG", "BQ", "CA", "CH", "CW", "CY", "CZ", "DE", "DK", "EE", "ES", "FI", "FO", "FR", "GB", "GG", "GI", "GL", "GR", "HR", "HU", "IE", "IL", "IM", "IS", "IT", "JE", "LI", "LT", "LU", "LV", "MC", "MD", "ME", "MF", "MK", "MT", "NL", "NO", "NZ", "PL", "PM", "PT", "RO", "RS", "SE", "SI", "SJ", "SK", "SM", "SX", "TR", "UA", "UM", "US", "VA", "VC", "XK", "YK", "EU");
    private static final List<String> DR4 = Arrays.asList("RU");

    public static String country2DR(String string) {
        if (!CountryCodeUtil.isCodeValidate(string)) {
            return "DR3";
        }
        if (DR1.contains(string = string.toUpperCase(Locale.ENGLISH))) {
            return DR1_NAME;
        }
        if (DR2.contains(string)) {
            return DR2_NAME;
        }
        if (DR3.contains(string)) {
            return "DR3";
        }
        if (DR4.contains(string)) {
            return DR4_NAME;
        }
        return "DR3";
    }

    public static boolean isDR1(String string) {
        return DR1_NAME.equals(CountryConfig.country2DR(string));
    }

    public static boolean isDR2(String string) {
        return DR2_NAME.equals(CountryConfig.country2DR(string));
    }

    public static boolean isDR3(String string) {
        return "DR3".equals(CountryConfig.country2DR(string));
    }

    public static boolean isDR4(String string) {
        return DR4_NAME.equals(CountryConfig.country2DR(string));
    }

    public static boolean isDRCountry(String string) {
        if (!CountryCodeUtil.isCodeValidate(string)) {
            return false;
        }
        return DR1.contains(string = string.toUpperCase(Locale.ROOT)) || DR2.contains(string) || DR3.contains(string) || DR4.contains(string);
    }
}

