/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.country;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.huawei.location.lite.common.util.country.CountryCodeUtil;
import com.huawei.location.lite.common.util.country.CountryConfig;
import java.util.Locale;

public class CountryUtil {
    private static final String COUNTRY_KR = "KR";

    public static boolean isKR() {
        return TextUtils.equals((CharSequence)CountryCodeUtil.getPrivacyCountryCode().toUpperCase(Locale.ENGLISH), (CharSequence)COUNTRY_KR);
    }

    public static boolean isKR(String string) {
        return TextUtils.equals((CharSequence)string.toUpperCase(Locale.ENGLISH), (CharSequence)COUNTRY_KR);
    }

    public static boolean isCN() {
        return CountryConfig.isDR1(CountryCodeUtil.getPrivacyCountryCode());
    }

    public static boolean isEU() {
        return CountryConfig.isDR3(CountryCodeUtil.getPrivacyCountryCode());
    }

    public static boolean isRU() {
        return CountryConfig.isDR4(CountryCodeUtil.getPrivacyCountryCode());
    }

    public static boolean isAALA() {
        return CountryConfig.isDR2(CountryCodeUtil.getPrivacyCountryCode());
    }

    public static boolean isRuOrAala() {
        return CountryConfig.isDR2(CountryCodeUtil.getPrivacyCountryCode()) || CountryConfig.isDR4(CountryCodeUtil.getPrivacyCountryCode());
    }

    public static String getLanguageForRemoteUri(Context object) {
        Context context = object;
        String string = CountryUtil.getScript(context);
        String string2 = CountryUtil.getLanguage(context);
        object = CountryUtil.getCountry(object).toUpperCase(Locale.getDefault());
        return TextUtils.isEmpty((CharSequence)string) ? string2 + "_" + (String)object : string2 + "_" + string + "_" + (String)object;
    }

    public static String getLanguageCode(Context object) {
        Context context = object;
        String string = CountryUtil.getScript(context);
        String string2 = CountryUtil.getLanguage(context);
        object = CountryUtil.getCountry(object).toUpperCase(Locale.getDefault());
        return TextUtils.isEmpty((CharSequence)string) ? string2 + "-" + (String)object : string2 + "-" + string + "-" + (String)object;
    }

    public static String getLanguageCodeWithoutCountry(Context object) {
        Context context = object;
        object = CountryUtil.getScript(context);
        String string = CountryUtil.getLanguage(context);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            string = string + "-" + (String)object;
        }
        return string;
    }

    private static String getScript(Context context) {
        context = context.getResources().getConfiguration();
        return Build.VERSION.SDK_INT >= 21 ? context.locale.getScript() : "";
    }

    private static String getLanguage(Context context) {
        return context.getResources().getConfiguration().locale.getLanguage().toLowerCase(Locale.getDefault());
    }

    private static String getCountry(Context context) {
        return context.getResources().getConfiguration().locale.getCountry().toLowerCase(Locale.getDefault());
    }
}

