/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.filedownload;

import android.os.Parcelable;
import com.huawei.location.lite.common.chain.Data;
import com.huawei.location.lite.common.chain.TaskClient;
import com.huawei.location.lite.common.chain.TaskFinishCallBack;
import com.huawei.location.lite.common.chain.TaskRequest;
import com.huawei.location.lite.common.chain.TaskTimeOutException;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.filedownload.DownLoadFileBean;
import com.huawei.location.lite.common.util.filedownload.DownloadFileParam;
import com.huawei.location.lite.common.util.filedownload.DownloadFileTask;
import com.huawei.location.lite.common.util.filedownload.DownloadUrlReqTask;
import com.huawei.location.lite.common.util.filedownload.IDownloadResult;
import com.huawei.location.lite.common.util.filedownload.IDownloadSupport;
import java.io.File;

public class DownLoadFileManager
implements TaskFinishCallBack {
    private static final String TAG = "DownLoadFileManager";
    private DownloadFileParam downloadFileParam;
    private IDownloadSupport iDownloadSupport;
    private IDownloadResult iDownloadResult;

    public DownLoadFileManager(DownloadFileParam downloadFileParam) {
        this.downloadFileParam = downloadFileParam;
    }

    public DownLoadFileManager(DownloadFileParam downloadFileParam, IDownloadSupport iDownloadSupport) {
        this(downloadFileParam);
        this.iDownloadSupport = iDownloadSupport;
    }

    public void startDownloadTask(IDownloadResult object) {
        TaskRequest taskRequest;
        this.iDownloadResult = object;
        Object object2 = object = taskRequest;
        ((TaskRequest)object2)();
        ((TaskRequest)object2).setMaxTimeOut(300000);
        ((TaskRequest)object2).setInputData(new Data.Builder().putParcelable("download_file_param", this.downloadFileParam).build());
        taskRequest.setTaskFinishCallBack(this);
        TaskClient.Builder builder = new TaskClient.Builder();
        builder.addTask(new DownloadUrlReqTask());
        DownloadFileTask downloadFileTask = new DownloadFileTask();
        downloadFileTask.setiDownloadSupport(this.iDownloadSupport);
        builder.addTask(downloadFileTask);
        try {
            builder.withTaskRequest((TaskRequest)object).build().runTasks();
        }
        catch (TaskTimeOutException taskTimeOutException) {
            LogLocation.e(TAG, "download file timeout");
        }
    }

    @Override
    public void onFail(Data data) {
        IDownloadResult iDownloadResult = ((DownLoadFileManager)((Object)iDownloadResult)).iDownloadResult;
        if (iDownloadResult != null) {
            Data data2 = data;
            int n = data2.getInt("download_result_code_key", 0);
            iDownloadResult.onFail(n, data2.getString("download_result_desc_key"));
        }
    }

    @Override
    public void onSuccess(Data data) {
        LogLocation.i(TAG, "download file Success.");
        if (((DownLoadFileManager)((Object)file)).iDownloadResult == null) {
            LogLocation.e(TAG, "iDownloadResult is empty.please setting");
            return;
        }
        Parcelable parcelable = data.getParcelable("download_entity");
        if (!(parcelable instanceof DownLoadFileBean)) {
            LogLocation.e(TAG, "return data exception");
            return;
        }
        parcelable = (DownLoadFileBean)parcelable;
        if (data.getKeyValueMap().get("download_file") instanceof File) {
            DownLoadFileManager downLoadFileManager = file;
            File file = (File)data.getKeyValueMap().get("download_file");
            downLoadFileManager.iDownloadResult.onSuccess((DownLoadFileBean)parcelable, file);
        }
    }
}

