/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.filedownload;

import android.text.TextUtils;
import android.webkit.URLUtil;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.chain.Data;
import com.huawei.location.lite.common.chain.Result;
import com.huawei.location.lite.common.chain.Task;
import com.huawei.location.lite.common.http.HttpClientEx;
import com.huawei.location.lite.common.http.adapter.HttpClientBuilder;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.filedownload.DownLoadFileBean;
import com.huawei.location.lite.common.util.filedownload.DownloadBaseTask;
import com.huawei.location.lite.common.util.filedownload.DownloadFileParam;
import com.huawei.location.lite.common.util.filedownload.IDownloadSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;

public class DownloadFileTask
extends DownloadBaseTask {
    private static final String TAG = "DownloadFileTask";
    private IDownloadSupport iDownloadSupport;

    private void requestDownLoadFileStream(DownLoadFileBean object) {
        String string = ((DownLoadFileBean)object).getFileAccessInfo().getVersion();
        DownLoadFileBean downLoadFileBean = object;
        object = downLoadFileBean.getFileAccessInfo().getUrl();
        Object object2 = downLoadFileBean.getFileAccessInfo().getFileSha256();
        if (!(TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)object2))) {
            RequestJsonBody.Builder builder;
            HeadBuilder headBuilder;
            StringBuilder stringBuilder;
            URI uRI;
            DownloadFileTask downloadFileTask;
            if (!this.isDownLoadFileVality((String)object, (String)object2)) {
                this.setNextFail(10004, "download url not https or sha256 error");
                return;
            }
            try {
                downloadFileTask = this;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.setNextFail(10004, "download url MalformedURLException");
                LogLocation.e(TAG, "MalformedURLException");
                return;
            }
            object2 = uRI;
            if (!downloadFileTask.uriCheck(new URI((String)object))) {
                this.setNextFail(10004, "download url format error");
                return;
            }
            DownloadFileTask downloadFileTask2 = this;
            object = stringBuilder;
            ((StringBuilder)object)(0);
            stringBuilder.append(((URI)object2).getScheme()).append("://").append(((URI)object2).getHost());
            object2 = downloadFileTask2.getRequestPath((URI)object2);
            HeadBuilder headBuilder2 = headBuilder;
            headBuilder = new HeadBuilder(UUID.randomUUID().toString());
            RequestJsonBody.Builder builder2 = builder;
            builder = new RequestJsonBody.Builder();
            object = new BaseRequest.Builder(((StringBuilder)object2).toString()).setHeads(headBuilder2).setBody(builder2.build()).setBaseUrl(((StringBuilder)object).toString()).setMethod("GET");
            try {
                downloadFileTask2.downLoadSuccessDeal(new HttpClientEx(ContextUtil.getHMSContext(), new HttpClientBuilder().setNeedInterceptor(false)).newSubmit(((BaseRequest.Builder)object).build()).executeOriginal());
            }
            catch (OnFailureException onFailureException) {
                LogLocation.e(TAG, "errorCode====" + onFailureException.getErrorCode().code + "errorMsg=====" + onFailureException.getErrorCode().msg);
                this.setNextFail(onFailureException.getErrorCode().code, onFailureException.getErrorCode().msg);
            }
            catch (OnErrorException onErrorException) {
                LogLocation.e(TAG, "apiErrorCode====" + onErrorException.getApiCode() + "apiErrorMsg=====" + onErrorException.getApiMsg());
                this.setNextFail(onErrorException.getErrorCode().code, onErrorException.getErrorCode().msg);
            }
            return;
        }
        this.setNextFail(10004, "download url format error with empty data");
    }

    private void downLoadSuccessDeal(byte[] object) {
        DownloadFileParam downloadFileParam;
        if (object != null && ((byte[])object).length > 0 && (downloadFileParam = ((DownloadBaseTask)((Object)result)).downloadFileParam) != null) {
            DownloadFileTask downloadFileTask = result;
            object = downloadFileTask.saveToSd(downloadFileParam.getSaveFilePath(), ((DownloadBaseTask)((Object)result)).downloadFileParam.getFileName(), (byte[])object);
            DownloadFileTask downloadFileTask2 = result;
            Result result = Result.success(new Data.Builder().putAll(((DownloadBaseTask)((Object)result)).taskRequest.getOutputData()).put("download_file", object).build());
            downloadFileTask.taskRequest.setResult(result, downloadFileTask2.downloadChain);
            return;
        }
        LogLocation.e(TAG, "responseBody is null");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File saveToSd(String object, String string, byte[] byArray) {
        FileOutputStream fileOutputStream;
        File file;
        File file2 = file;
        file = new File((String)object, string);
        object = fileOutputStream;
        byte[] byArray2 = byArray;
        byte[] byArray3 = byArray;
        ((FileOutputStream)object)(file2, false);
        int n = 0;
        fileOutputStream.write(byArray3, n, byArray2.length);
        fileOutputStream.flush();
        fileOutputStream.close();
        return file2;
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    ((FileOutputStream)object).close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        LogLocation.e(TAG, "saveToSd createSdFile stream read write exception");
                    }
                }
            }
        }
        return file2;
    }

    private boolean uriCheck(URI uRI) {
        if (uRI == null) {
            LogLocation.e(TAG, "uri is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)uRI.getScheme())) {
            LogLocation.e(TAG, "uri scheme is undefined");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)uRI.getHost())) {
            LogLocation.e(TAG, "uri host is undefined");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)uRI.getPath())) {
            LogLocation.e(TAG, "uri path is undefined");
            return false;
        }
        return true;
    }

    private StringBuilder getRequestPath(URI uRI) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(0);
        stringBuilder.append(uRI.getPath());
        if (!TextUtils.isEmpty((CharSequence)uRI.getQuery())) {
            stringBuilder2.append("?");
            stringBuilder2.append(uRI.getQuery());
        }
        return stringBuilder2;
    }

    private boolean isDownLoadFileVality(String string, String string2) {
        return !TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2) && URLUtil.isHttpsUrl((String)string);
    }

    @Override
    public void runTask(Task.Chain object) {
        DownloadFileTask downloadFileTask = this;
        super.runTask((Task.Chain)object);
        object = downloadFileTask.taskRequest.getOutputData().getParcelable("download_entity");
        if (!(object instanceof DownLoadFileBean)) {
            this.setNextFail(10003, "The data format error");
            return;
        }
        object = (DownLoadFileBean)object;
        IDownloadSupport iDownloadSupport = this.iDownloadSupport;
        if (iDownloadSupport != null && !iDownloadSupport.isSupportDownloadFile((DownLoadFileBean)object)) {
            this.setNextFail(10005, "business not need download file");
            return;
        }
        this.requestDownLoadFileStream((DownLoadFileBean)object);
    }

    public void setiDownloadSupport(IDownloadSupport iDownloadSupport) {
        this.iDownloadSupport = iDownloadSupport;
    }
}

