/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.filedownload;

import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.chain.Data;
import com.huawei.location.lite.common.chain.Result;
import com.huawei.location.lite.common.chain.Task;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.http.HttpClientEx;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.filedownload.DownLoadFileBean;
import com.huawei.location.lite.common.util.filedownload.DownloadBaseTask;
import com.huawei.location.lite.common.util.filedownload.DownloadFileParam;
import java.util.UUID;

public class DownloadUrlReqTask
extends DownloadBaseTask {
    private static final String TAG = "ReqDownloadUrlTask";

    private void requestDownloadUrl(String object, String string) {
        HeadBuilder headBuilder;
        String string2 = UUID.randomUUID().toString();
        HeadBuilder headBuilder2 = headBuilder;
        headBuilder = new HeadBuilder(string2);
        object = new BaseRequest.Builder("/location/v1/getFileDownloadUrl").setHeads(headBuilder2).setBody(new RequestJsonBody.Builder().add("serviceType", (String)object).add("subType", string).build()).setBaseUrl(LocationNlpGrsHelper.getGrsHostAddress("com.huawei.hms.location")).setMethod("POST");
        object = new HttpClientEx(ContextUtil.getHMSContext()).newSubmit(((BaseRequest.Builder)object).build()).execute(DownLoadFileBean.class);
        try {
            LogLocation.i(TAG, "url request success url and fileVersion:" + ((DownLoadFileBean)object).getFileAccessInfo().getVersion());
            this.setNextSuccess((DownLoadFileBean)object);
        }
        catch (OnFailureException onFailureException) {
            LogLocation.e(TAG, "errorCode====" + onFailureException.getErrorCode().code + "errorMsg=====" + onFailureException.getErrorCode().msg);
            this.setNextFail(onFailureException.getErrorCode().code, onFailureException.getErrorCode().msg);
        }
        catch (OnErrorException onErrorException) {
            LogLocation.e(TAG, "apiErrorCode====" + onErrorException.getApiCode() + "apiErrorMsg=====" + onErrorException.getApiMsg());
            this.setNextFail(onErrorException.getErrorCode().code, onErrorException.getErrorCode().msg);
        }
    }

    private void setNextSuccess(DownLoadFileBean downLoadFileBean) {
        DownloadUrlReqTask downloadUrlReqTask = result;
        Result result = Result.success(new Data.Builder().putAll(((DownloadBaseTask)((Object)result)).taskRequest.getOutputData()).putParcelable("download_entity", downLoadFileBean).build());
        ((DownloadBaseTask)((Object)result)).taskRequest.setResult(result, downloadUrlReqTask.downloadChain);
    }

    @Override
    public void runTask(Task.Chain object) {
        DownloadUrlReqTask downloadUrlReqTask = this;
        super.runTask((Task.Chain)object);
        object = downloadUrlReqTask.downloadFileParam;
        if (object == null) {
            this.setNextFail(10000, "param error");
            return;
        }
        object = ((DownloadFileParam)object).getServiceType();
        String string = this.downloadFileParam.getSubType();
        if (!TextUtils.isEmpty((CharSequence)object) && !TextUtils.isEmpty((CharSequence)string)) {
            this.requestDownloadUrl((String)object, string);
            return;
        }
        this.setNextFail(10000, "param error");
    }
}

