/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.lite.common.util.unzip;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.plug.PluginManager;
import com.huawei.location.lite.common.plug.PluginReqMessage;
import com.huawei.location.lite.common.report.ReportBuilder;
import com.huawei.location.lite.common.report.Tracker;
import com.huawei.location.lite.common.util.GsonUtil;
import com.huawei.location.lite.common.util.SDKComponentType;
import com.huawei.location.lite.common.util.unzip.IUnzip;
import com.huawei.location.lite.common.util.unzip.Un7Z;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class AssetUnZipManager {
    private static final String TAG = "AssetUnZipManager";
    private static final int ASSET_FOR_ERROR = 100;
    private static final int UN7Z_ERROR = 101;
    private IUnzip iUnzip;
    private String assetDirPath;
    private List<String> filterZipDirs;
    private List<String> filterZipFiles;
    private final int maxTryTimes;
    private int tryTime;
    private int errorCode;

    public AssetUnZipManager() {
        Un7Z un7Z;
        AssetUnZipManager assetUnZipManager = un7Z2;
        Un7Z un7Z2 = un7Z;
        un7Z = new Un7Z();
        assetUnZipManager(null, un7Z2);
    }

    public AssetUnZipManager(String string, IUnzip iUnzip) {
        this.maxTryTimes = 3;
        this.tryTime = 0;
        this.errorCode = 101;
        this.assetDirPath = string;
        this.iUnzip = iUnzip;
    }

    private void reportAssetUnZipResult() {
        ReportBuilder reportBuilder;
        ReportBuilder reportBuilder2;
        ReportBuilder reportBuilder3 = reportBuilder2 = reportBuilder;
        reportBuilder3();
        reportBuilder3.setApiName(TAG);
        reportBuilder.setErrorCode(String.valueOf(((AssetUnZipManager)((Object)pluginReqMessage2)).errorCode));
        if (SDKComponentType.getComponentType() == 200) {
            PluginReqMessage pluginReqMessage;
            PluginReqMessage pluginReqMessage2 = pluginReqMessage;
            new PluginReqMessage().setData(GsonUtil.getInstance().toJson((Object)reportBuilder2));
            Bundle bundle = new Bundle();
            bundle.putString("report_type", "event_operation");
            pluginReqMessage2.setExtraData(bundle);
            PluginManager.getInstance().startFunction(102, "report", pluginReqMessage2, null);
        } else {
            Tracker.getInstance().onMaintEvent(reportBuilder2);
            Tracker.getInstance().onOperationEvent(reportBuilder2);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File createFileFromInputStream(Context object, String object2, String object3) {
        FileOutputStream fileOutputStream;
        File file;
        File file2 = file;
        file = new File(object.getCacheDir(), (String)object2);
        if (!TextUtils.isEmpty((CharSequence)object3)) {
            object2 = (String)object3 + File.separator + (String)object2;
        }
        object = object.getAssets().open((String)object2, 3);
        object2 = fileOutputStream;
        fileOutputStream = new FileOutputStream(file2);
        object3 = new byte[1024];
        while (true) {
            int n = ((InputStream)object).read((byte[])object3);
            if (n <= 0) break;
            ((OutputStream)object2).write((byte[])object3, 0, n);
            continue;
            break;
        }
        Object object4 = object;
        ((OutputStream)object2).close();
        ((InputStream)object4).close();
        return file2;
        catch (Throwable throwable) {
            try {
                throw throwable;
            }
            catch (Throwable throwable2) {
                try {
                    ((OutputStream)object2).close();
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable.addSuppressed(throwable3);
                        throw throwable2;
                    }
                    catch (Throwable throwable4) {
                        try {
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (object == null) throw throwable5;
                            try {
                                ((InputStream)object).close();
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                try {
                                    throwable4.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                                catch (IOException iOException) {
                                    LogLocation.e(TAG, "createFileFromInputStream : IOException");
                                }
                            }
                        }
                    }
                }
            }
        }
        return file2;
    }

    public boolean copyZipFileFromAssets(String string) {
        boolean bl;
        block18: {
            block17: {
                if (this.tryTime >= 3) {
                    LogLocation.e(TAG, "maxTryTime failed");
                    this.reportAssetUnZipResult();
                    return false;
                }
                bl = false;
                String[] stringArray = ContextUtil.getContext().getAssets().list(this.assetDirPath);
                if (stringArray == null) break block17;
                if (stringArray.length <= 0) break block17;
                int n = 0;
                while (true) {
                    block19: {
                        if (n >= stringArray.length) break block18;
                        if (!this.iUnzip.isSupportUnZip(stringArray[n])) break block19;
                        Context context = ContextUtil.getContext();
                        AssetUnZipManager assetUnZipManager = this;
                        Object object = stringArray[n];
                        File file = AssetUnZipManager.createFileFromInputStream(context, (String)object, assetUnZipManager.assetDirPath);
                        object = file;
                        IUnzip iUnzip = this.iUnzip;
                        AssetUnZipManager assetUnZipManager2 = this;
                        AssetUnZipManager assetUnZipManager3 = assetUnZipManager2;
                        AssetUnZipManager assetUnZipManager4 = assetUnZipManager2;
                        object = ((File)object).getCanonicalPath();
                        List<String> list = assetUnZipManager3.filterZipDirs;
                        List<String> list2 = assetUnZipManager4.filterZipFiles;
                        bl = iUnzip.doUnzip((String)object, string, list, list2);
                        if (file.delete()) break block19;
                        LogLocation.e(TAG, "delete file exception");
                    }
                    ++n;
                }
            }
            try {
                LogLocation.e(TAG, "jnilib  asset file have not content");
                this.errorCode = 100;
            }
            catch (IOException iOException) {
                LogLocation.e(TAG, "copyFileFromAssets stream get asset exception");
            }
        }
        if (!bl) {
            LogLocation.e(TAG, "doUnzip fail");
            ++this.tryTime;
            return this.copyZipFileFromAssets(string);
        }
        return true;
    }

    public void setFilterZipDirs(List<String> list) {
        this.filterZipDirs = list;
    }

    public void setFilterZipFiles(List<String> list) {
        this.filterZipFiles = list;
    }
}

