/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.nlp.network;

import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import com.huawei.hms.location.HwLocationResult;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.grs.LocationNlpGrsHelper;
import com.huawei.location.lite.common.http.HttpClientEx;
import com.huawei.location.lite.common.http.exception.OnErrorException;
import com.huawei.location.lite.common.http.exception.OnFailureException;
import com.huawei.location.lite.common.http.request.BaseRequest;
import com.huawei.location.lite.common.http.request.HeadBuilder;
import com.huawei.location.lite.common.http.request.RequestJsonBody;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.GsonUtil;
import com.huawei.location.nlp.constant.yn;
import com.huawei.location.nlp.network.request.OnlineLocationRequest;
import com.huawei.location.nlp.network.response.Location;
import com.huawei.location.nlp.network.response.OnlineLocationResponse;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class OnlineLocationService {
    public static final String X_REQ_SRC = "X-Req-src";
    public static final String SRC_DEFAULT = "4";
    private static final String TAG = "OnlineLocationService";
    private static final String LOCATION_URL = "/networklocation/v1/onlineLocation";
    private static final int FLAG_SPEED = 4;
    private static final int FLAG_BEARING = 8;
    private static final int FLAG_ACCURACY = 16;

    private boolean convertNativeLocation(android.location.Location location, OnlineLocationResponse onlineLocationResponse) {
        Bundle bundle;
        Location location2 = onlineLocationResponse.getPosition();
        if (location2 == null) {
            LogLocation.e(TAG, "convertNativeLocation, responseLocation is null.");
            return false;
        }
        short s = location2.getFlags();
        if (s <= 0) {
            LogLocation.e(TAG, "convertNativeLocation, flag is invalid.");
            return false;
        }
        if ((s & 1) <= 0) {
            LogLocation.e(TAG, "convertNativeLocation, lon&lat is invalid.");
            return false;
        }
        location.setLatitude(location2.getLatitude());
        location.setLongitude(location2.getLongitude());
        if ((s & 4) != 0) {
            location.setSpeed(location2.getSpeed());
        }
        if ((s & 8) != 0) {
            location.setBearing(location2.getBearing());
        }
        if ((s & 0x10) != 0) {
            location.setAccuracy(location2.getAccuracy());
        }
        if (location2.getTime() <= 0L) {
            location.setTime(System.currentTimeMillis());
        } else {
            location.setTime(location2.getTime());
        }
        location.setProvider("network");
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)onlineLocationResponse.getSessionId())) {
            bundle2.putString("session_id", onlineLocationResponse.getSessionId());
        }
        bundle2.putInt("vendorType", 1);
        bundle2.putString("locateType", onlineLocationResponse.getLocateType());
        bundle2.putString("buildingId", location2.getBuildingId());
        bundle2.putInt("floor", location2.getFloor());
        bundle2.putInt("floorAcc", location2.getFloorAcc());
        long l = location2.getTime();
        bundle2.putLong("time", l);
        bundle2.putShort("flags", location2.getFlags());
        location.setExtras(bundle2);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OnlineLocationResponse doHttp(OnlineLocationRequest object) {
        HashMap<String, String> hashMap;
        JSONObject jSONObject;
        OnlineLocationResponse onlineLocationResponse;
        LogLocation.i(TAG, "doHttp, request is " + ((OnlineLocationRequest)object).toString());
        Object object2 = onlineLocationResponse;
        onlineLocationResponse = new OnlineLocationResponse();
        object = GsonUtil.getInstance().toJson(object);
        JSONObject jSONObject2 = jSONObject;
        try {
            jSONObject = new JSONObject((String)object);
        }
        catch (JSONException jSONException) {
            LogLocation.e(TAG, "doHttp, transfer to JSONException failed");
            return object2;
        }
        object = new RequestJsonBody.Builder().build(jSONObject2);
        String string = LocationNlpGrsHelper.getGrsHostAddress("com.huawei.hms.location");
        if (TextUtils.isEmpty((CharSequence)string)) {
            LogLocation.e(TAG, "grsHostAddress is null");
            return object2;
        }
        String string2 = ContextUtil.getContext().getPackageName();
        HashMap<String, String> hashMap2 = hashMap;
        new HashMap<String, String>().put(X_REQ_SRC, SRC_DEFAULT);
        String string3 = UUID.randomUUID().toString();
        HeadBuilder headBuilder = new HeadBuilder(string3).setPackageName(string2).addAll(hashMap2);
        object = new BaseRequest.Builder(LOCATION_URL).setBaseUrl(string).setHeads(headBuilder).setBody((RequestJsonBody)object).build();
        object2 = new HttpClientEx().newSubmit((BaseRequest)object).execute(OnlineLocationResponse.class);
        try {
            ((OnlineLocationResponse)object2).setSessionId(string3);
            LogLocation.i(TAG, "doHttp, response code is " + ((OnlineLocationResponse)object2).getApiCode());
            return object2;
        }
        catch (Exception exception) {
            LogLocation.e(TAG, "unknown exception");
            return object2;
        }
        catch (OnErrorException onErrorException) {
            LogLocation.e(TAG, "doHttp, OnErrorException: code is " + onErrorException.getApiCode() + ", msg is " + onErrorException.getApiMsg());
            return object2;
        }
        catch (OnFailureException onFailureException) {
            LogLocation.e(TAG, "doHttp, OnFailureException: code is " + onFailureException.getErrorCode() + ", msg is " + onFailureException.getMessage());
        }
        return object2;
    }

    public HwLocationResult getLocationFromCloud(OnlineLocationRequest object) {
        android.location.Location location;
        HwLocationResult hwLocationResult;
        OnlineLocationRequest onlineLocationRequest = object;
        onlineLocationRequest.setBoottime(SystemClock.elapsedRealtimeNanos() / 1000L);
        object = ((OnlineLocationService)((Object)string)).doHttp(onlineLocationRequest);
        HwLocationResult hwLocationResult2 = hwLocationResult;
        hwLocationResult = new HwLocationResult();
        android.location.Location location2 = location;
        location = new android.location.Location("network");
        if (!((OnlineLocationResponse)object).isSuccess()) {
            HwLocationResult hwLocationResult3 = hwLocationResult2;
            LogLocation.e(TAG, "getLocationFromCloud, response is failed");
            hwLocationResult3.setCode(11000);
            hwLocationResult3.setMessage(yn.yn(11000));
            return hwLocationResult3;
        }
        if (!((OnlineLocationService)((Object)string)).convertNativeLocation(location2, (OnlineLocationResponse)object)) {
            HwLocationResult hwLocationResult4 = hwLocationResult2;
            hwLocationResult4.setCode(11000);
            hwLocationResult4.setMessage(yn.yn(11000));
            return hwLocationResult4;
        }
        if (((OnlineLocationResponse)object).getIndoor() == 0) {
            String string = ((OnlineLocationResponse)object).getLocateType();
            if ("wifi".equalsIgnoreCase(string)) {
                location2.setElapsedRealtimeNanos(com.huawei.location.nlp.logic.yn.dC().d2());
            }
            if ("cell".equalsIgnoreCase(string)) {
                location2.setElapsedRealtimeNanos(com.huawei.location.nlp.logic.yn.dC().LW());
            }
        }
        HwLocationResult hwLocationResult5 = hwLocationResult2;
        HwLocationResult hwLocationResult6 = hwLocationResult2;
        hwLocationResult6.setCode(0);
        hwLocationResult6.setMessage(yn.yn(0));
        hwLocationResult5.setLocation(location2);
        return hwLocationResult5;
    }
}

