/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.router.dispatch;

import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.ExecutorManager;
import com.huawei.location.router.dispatch.DispatchCallable;
import com.huawei.location.router.dispatch.DispatchRunnable;
import com.huawei.location.router.dispatch.DispatchThreadPoolExecutor;
import com.huawei.location.router.entity.IRouterResponse;
import com.huawei.location.router.entity.RouterRequest;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DispatchTaskManager {
    private static final String LOCATION_DISPATCH_TASK_MANAGER = "Location_DispatchTaskManager";
    private static final int THREAD_CORE = Runtime.getRuntime().availableProcessors();
    private static final long KEEP_ALIVE_TIME = 60L;
    private static final int THREAD_TIME_OUT_SECONDS = 3;
    private ThreadPoolExecutor mExecutorService;

    public static DispatchTaskManager getInstance() {
        return Vw.yn;
    }

    private DispatchTaskManager() {
        DispatchTaskManager dispatchTaskManager = this;
        dispatchTaskManager.init();
    }

    private void init() {
        LinkedBlockingDeque<Runnable> linkedBlockingDeque;
        DispatchThreadPoolExecutor dispatchThreadPoolExecutor;
        DispatchThreadPoolExecutor dispatchThreadPoolExecutor2 = dispatchThreadPoolExecutor;
        int n = THREAD_CORE;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        LinkedBlockingDeque<Runnable> linkedBlockingDeque2 = linkedBlockingDeque;
        linkedBlockingDeque = new LinkedBlockingDeque<Runnable>();
        ThreadFactory threadFactory = ExecutorManager.createThreadFactory(LOCATION_DISPATCH_TASK_MANAGER);
        dispatchThreadPoolExecutor2(n, n * 2, 60L, timeUnit, linkedBlockingDeque2, threadFactory);
        this.mExecutorService = dispatchThreadPoolExecutor2;
        dispatchThreadPoolExecutor.allowCoreThreadTimeOut(true);
    }

    public void dispatchTask(RouterRequest routerRequest) {
        Object object = ((DispatchTaskManager)object).mExecutorService;
        if (object != null) {
            DispatchRunnable dispatchRunnable;
            Object object2 = object;
            object = dispatchRunnable;
            dispatchRunnable = new DispatchRunnable(routerRequest);
            ((ThreadPoolExecutor)object2).execute((Runnable)object);
        }
    }

    public IRouterResponse executeTask(RouterRequest routerRequest) {
        ThreadPoolExecutor threadPoolExecutor = ((DispatchTaskManager)((Object)threadPoolExecutor)).mExecutorService;
        if (threadPoolExecutor != null) {
            try {
                return threadPoolExecutor.submit(new DispatchCallable(routerRequest)).get(3L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {}
            LogLocation.e("DispatchTaskManager", "enqueue task failed");
        }
        return null;
    }

    private static class Vw {
        private static final DispatchTaskManager yn = new DispatchTaskManager();
    }
}

