/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.router.dispatch;

import com.huawei.location.router.BaseRouterTaskCallImpl;
import com.huawei.location.router.RouterTaskHandler;
import com.huawei.location.router.dispatch.DispatchBaseRunnable;
import com.huawei.location.router.dispatch.DispatchCallable;
import com.huawei.location.router.dispatch.DispatchException;
import com.huawei.location.router.dispatch.DispatchRunnable;
import com.huawei.location.router.dispatch.DispatchThreadExceptionHandler;
import com.huawei.location.router.dispatch.FutureDispatch;
import com.huawei.location.router.entity.RouterRequest;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DispatchThreadPoolExecutor
extends ThreadPoolExecutor {
    public DispatchThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    private void processRequest(DispatchBaseRunnable dispatchBaseRunnable) {
        Thread.setDefaultUncaughtExceptionHandler(new DispatchThreadExceptionHandler(dispatchBaseRunnable));
        Object object = dispatchBaseRunnable.getRouterRequest();
        if (object != null) {
            object = RouterTaskHandler.getInstance().getApiRequestMap().get(((RouterRequest)object).getApiName());
            if (object != null) {
                try {
                    dispatchBaseRunnable.setApiRequest((BaseRouterTaskCallImpl)Class.forName((String)object).newInstance());
                    return;
                }
                catch (Exception exception) {
                    throw new DispatchException(10003, "InstantiationException");
                }
                catch (InstantiationException instantiationException) {
                    throw new DispatchException(10003, "InstantiationException");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new DispatchException(10003, "IllegalAccessException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new DispatchException(10003, "class not found exception");
                }
            }
            throw new DispatchException(10001, "api interface not register");
        }
        throw new DispatchException(10002, "TaskApiEntity Object is Empty");
    }

    @Override
    protected void beforeExecute(Thread object, Runnable runnable) {
        super.beforeExecute((Thread)object, runnable);
        if (runnable instanceof DispatchRunnable) {
            this.processRequest((DispatchRunnable)runnable);
        }
        if (runnable instanceof FutureDispatch && (object = ((FutureDispatch)runnable).getCallable()) instanceof DispatchCallable) {
            this.processRequest((DispatchCallable)object);
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new FutureDispatch<T>(callable);
    }
}

