/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.location.vdr;

import android.location.Location;
import android.os.Bundle;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.util.ExecutorUtil;
import com.huawei.location.lite.common.util.GsonUtil;
import com.huawei.location.vdr.data.LW;
import com.huawei.location.vdr.listener.IVdrLocationListener;
import com.huawei.location.vdr.listener.Vw;
import com.huawei.location.vdr.util.FB;
import com.huawei.riemann.gnsslocation.api.vdr.VdrLocationClient;
import com.huawei.riemann.gnsslocation.core.bean.eph.Ephemeris;
import com.huawei.riemann.gnsslocation.core.bean.obs.GnssRawObservation;
import com.huawei.riemann.gnsslocation.core.bean.obs.Pvt;
import com.huawei.secure.android.common.intent.SafeBundle;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(api=24)
public class VdrManager
implements Vw,
com.huawei.location.vdr.listener.FB {
    private static final String TAG = "VdrManager";
    private static volatile VdrManager instance;
    private static final byte[] VDR_SYNC_LOCK;
    private static final long SYNC_LOCATION_UPDATE_TIME = 200L;
    private static final String EPH_THREAD_NAME = "Loc-Vdr-EphUpdate";
    private static final long EPH_UPDATE_TIME = 30L;
    private volatile long lastSyncTime;
    private VdrLocationClient vdrLocationClient;
    private final AtomicBoolean isVdrStart;
    private com.huawei.location.vdr.data.ephemeris.yn ephProvider;
    private LW vdrDataManager;
    private long ephExpiredTime = 0L;
    private Ephemeris currentEphemeris;
    private final AtomicBoolean updateEphemeris;

    private VdrManager() {
        AtomicBoolean atomicBoolean;
        AtomicBoolean atomicBoolean2;
        LogLocation.i(TAG, "VdrManager init");
        Object object = atomicBoolean2;
        atomicBoolean2 = new AtomicBoolean(false);
        v1.isVdrStart = object;
        object = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.updateEphemeris = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VdrManager getInstance() {
        if (instance != null) return instance;
        byte[] byArray = VDR_SYNC_LOCK;
        synchronized (VDR_SYNC_LOCK) {
            if (instance != null) return instance;
            instance = new VdrManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void loadVdrFile() {
        new com.huawei.location.vdr.file.yn().yn(this);
    }

    private void initVdrDataManager() {
        com.huawei.location.vdr.data.ephemeris.yn yn2;
        LW lW;
        VdrManager vdrManager = yn3;
        LW lW2 = lW;
        lW2();
        ((VdrManager)((Object)yn3)).vdrDataManager = lW2;
        lW.yn((Vw)((Object)yn3));
        com.huawei.location.vdr.data.ephemeris.yn yn3 = yn2;
        yn2 = new com.huawei.location.vdr.data.ephemeris.yn();
        vdrManager.ephProvider = yn3;
    }

    private void startVdrAlgo() {
        this.vdrLocationClient = new VdrLocationClient(ContextUtil.getContext(), FB.Vw);
        Object object = this.isVdrStart;
        boolean bl = this.vdrLocationClient.startLocation(com.huawei.location.activity.model.Vw.Vw()) == 0;
        ((AtomicBoolean)object).set(bl);
        object = this.ephProvider.yn();
        if (object != null) {
            VdrManager vdrManager = this;
            vdrManager.ephExpiredTime = vdrManager.ephProvider.FB();
            LogLocation.i(TAG, "updateEphemeris GpsEphemeris:" + GsonUtil.getInstance().toJson((Object)((Ephemeris)object).getGpsEphemeris()));
            vdrManager.vdrLocationClient.updateEphemeris((Ephemeris)object);
        }
    }

    private boolean checkAndUpdateEphemeris() {
        com.huawei.location.vdr.data.ephemeris.Vw vw;
        VdrManager vdrManager = this;
        com.huawei.location.vdr.data.ephemeris.Vw vw2 = vw;
        vdrManager.updateEphemeris(new com.huawei.location.vdr.data.ephemeris.Vw(System.currentTimeMillis()).Vw());
        if (vdrManager.updateEphemeris.get() && this.currentEphemeris != null) {
            VdrManager vdrManager2 = this;
            LogLocation.i(TAG, "updateEphemeris GpsEphemeris:" + GsonUtil.getInstance().toJson((Object)this.currentEphemeris.getGpsEphemeris()));
            vdrManager2.vdrLocationClient.updateEphemeris(this.currentEphemeris);
            vdrManager2.updateEphemeris.set(false);
        }
        return vw2.Vw() < this.ephExpiredTime;
    }

    private void updateEphemeris(long l) {
        LogLocation.i(TAG, "currentGpsTime is : " + l + ", ephExpiredTime is : " + this.ephExpiredTime);
        if (l + 30L < this.ephExpiredTime) {
            return;
        }
        ExecutorUtil.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                yn yn2 = this;
                Thread.currentThread().setName(VdrManager.EPH_THREAD_NAME + this.hashCode());
                VdrManager vdrManager = yn2.VdrManager.this;
                VdrManager.access$002(vdrManager, vdrManager.ephProvider.Vw());
                if (yn2.VdrManager.this.currentEphemeris != null) {
                    yn yn3 = this;
                    VdrManager vdrManager2 = yn3.VdrManager.this;
                    VdrManager.access$202(vdrManager2, vdrManager2.ephProvider.FB());
                    yn3.VdrManager.this.updateEphemeris.set(true);
                }
            }
        });
    }

    private synchronized void processVdrData(com.huawei.location.vdr.data.FB fB) {
        if (com.huawei.location.vdr.listener.LW.yn().Vw()) {
            LogLocation.e(TAG, "vdr listener is null");
            return;
        }
        if (this.vdrLocationClient == null) {
            LogLocation.e(TAG, "vdrLocationClient init failed");
            this.handlerNativeLocationToVdr();
            return;
        }
        if (fB == null) {
            LogLocation.e(TAG, "vdr data is null");
            this.handlerNativeLocationToVdr();
            return;
        }
        if (!this.checkAndUpdateEphemeris()) {
            LogLocation.i(TAG, "checkAndUpdateEphemeris failed,stop algo");
            if (this.isVdrStart.get()) {
                this.vdrLocationClient.stopLocation();
            }
            VdrManager vdrManager = this;
            vdrManager.isVdrStart.set(false);
            vdrManager.handlerNativeLocationToVdr();
            return;
        }
        if (!this.isVdrStart.get()) {
            if (!this.checkFirstRequestDataIsValid(fB)) {
                LogLocation.d(TAG, "first requestData is not valid,dropping it!");
                this.handlerNativeLocationToVdr();
                return;
            }
            int n = this.vdrLocationClient.startLocation(com.huawei.location.activity.model.Vw.Vw());
            LogLocation.i(TAG, "processGnssLocation startLocation status:" + n);
            if (n == 0) {
                this.isVdrStart.set(true);
            } else {
                VdrManager vdrManager = this;
                vdrManager.isVdrStart.set(false);
                vdrManager.handlerNativeLocationToVdr();
                return;
            }
        }
        this.handlerVdrLocation(fB);
    }

    private boolean checkFirstRequestDataIsValid(com.huawei.location.vdr.data.FB fB) {
        return fB.Vw() != null && fB.yn() != null && fB.FB() != null;
    }

    private void handlerVdrLocation(com.huawei.location.vdr.data.FB object) {
        Pvt pvt = null;
        Location location = ((com.huawei.location.vdr.data.FB)object).Vw();
        if (location != null) {
            pvt = Pvt.Builder.aPvt().withAccuracy(location.getAccuracy()).withAltitude(location.getAltitude()).withLatitude(location.getLatitude()).withLongitude(location.getLongitude()).withBearing(location.getBearing()).withSpeed(location.getSpeed()).withTime(location.getTime()).build();
        }
        LogLocation.d(TAG, "process vdr start");
        object = ((com.huawei.location.vdr.data.FB)object).yn();
        object = ((VdrManager)((Object)lW)).vdrLocationClient.process(pvt, (GnssRawObservation[])object, ((com.huawei.location.vdr.data.FB)object).FB(), null);
        if (object != null && ((Pvt)object).getLatitude() != 0.0 && ((Pvt)object).getLongitude() != 0.0) {
            SafeBundle safeBundle;
            LogLocation.i(TAG, "process vdr end, errorCode is: " + ((Pvt)object).getErrCode());
            com.huawei.location.vdr.listener.LW lW = com.huawei.location.vdr.listener.LW.yn();
            if (location == null) {
                Location location2;
                location = location2;
                location2 = new Location("GPS");
            }
            Object object2 = object;
            Location location3 = location;
            Location location4 = location;
            location4.setTime(System.currentTimeMillis());
            location4.setElapsedRealtimeNanos(SystemClock.elapsedRealtimeNanos());
            location.setLongitude(((Pvt)object).getLongitude());
            location.setLatitude(((Pvt)object).getLatitude());
            location.setAltitude(((Pvt)object).getAltitude());
            location.setAccuracy(((Pvt)object).getAccuracy());
            location.setBearing(((Pvt)object).getBearing());
            location3.setSpeed(((Pvt)object).getSpeed());
            object = location3.getExtras();
            pvt = safeBundle;
            safeBundle = new SafeBundle((Bundle)object);
            if (((Pvt)object2).getErrCode() == 1) {
                if (pvt.containsKey("LocationSource")) {
                    pvt.putInt("LocationSource", object.getInt("LocationSource") | 2);
                } else {
                    pvt.putInt("LocationSource", 2);
                }
            }
            Location location5 = location;
            location5.setExtras(pvt.getBundle());
            lW.yn(location5);
        } else {
            ((VdrManager)((Object)lW)).handlerNativeLocationToVdr();
        }
    }

    private void handlerNativeLocationToVdr() {
        LogLocation.i(TAG, "vdr process fail, return native location here");
        LW lW = this.vdrDataManager;
        if (lW != null && lW.yn() != null) {
            com.huawei.location.vdr.listener.LW.yn().yn(this.vdrDataManager.yn());
        }
    }

    private void clearVdr() {
        Object object = this.vdrDataManager;
        if (object != null) {
            ((LW)object).Vw();
            this.vdrDataManager = null;
        }
        if ((object = this.vdrLocationClient) != null) {
            ((VdrLocationClient)object).stopLocation();
            this.vdrLocationClient = null;
        }
    }

    static /* synthetic */ Ephemeris access$002(VdrManager vdrManager, Ephemeris ephemeris) {
        vdrManager.currentEphemeris = ephemeris;
        return ephemeris;
    }

    static /* synthetic */ long access$202(VdrManager vdrManager, long l) {
        vdrManager.ephExpiredTime = l;
        return l;
    }

    static {
        VDR_SYNC_LOCK = new byte[0];
    }

    public boolean isVdrIntervalStart() {
        return this.vdrDataManager != null;
    }

    public synchronized void syncLocation(Location location) {
        LogLocation.d(TAG, "ElapsedRealtimeNanos time is: " + location.getElapsedRealtimeNanos() + ", lastSyncTime is: " + this.lastSyncTime);
        if (location.getElapsedRealtimeNanos() - this.lastSyncTime < 200L) {
            return;
        }
        LW lW = this.vdrDataManager;
        if (lW != null) {
            lW.yn(location);
            this.lastSyncTime = location.getElapsedRealtimeNanos();
        }
    }

    public synchronized void registerVdrLocationLis(IVdrLocationListener iVdrLocationListener) {
        com.huawei.location.vdr.listener.LW.yn().Vw(iVdrLocationListener);
        if (!this.isVdrIntervalStart()) {
            this.loadVdrFile();
        }
    }

    public synchronized void unRegisterVdrLocationLis(String string) {
        com.huawei.location.vdr.listener.LW.yn().yn(string);
        if (com.huawei.location.vdr.listener.LW.yn().Vw()) {
            this.clearVdr();
            LogLocation.i(TAG, "stop vdr manager");
        }
    }

    @Override
    public synchronized void onVdrDataReceived(com.huawei.location.vdr.data.FB fB) {
        this.processVdrData(fB);
    }

    @Override
    public synchronized void handleLoadResult(boolean bl) {
        if (bl) {
            VdrManager vdrManager = this;
            vdrManager.initVdrDataManager();
            vdrManager.startVdrAlgo();
        }
    }
}

