/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.riemann.gnsslocation.api.vdr;

import android.content.Context;
import android.util.Log;
import com.huawei.location.FB;
import com.huawei.riemann.gnsslocation.core.VdrLocationAlgoWrapper;
import com.huawei.riemann.gnsslocation.core.bean.DeviceInfo;
import com.huawei.riemann.gnsslocation.core.bean.eph.Ephemeris;
import com.huawei.riemann.gnsslocation.core.bean.obs.GnssClock;
import com.huawei.riemann.gnsslocation.core.bean.obs.GnssRawObservation;
import com.huawei.riemann.gnsslocation.core.bean.obs.Pvt;
import com.huawei.riemann.gnsslocation.core.bean.obs.SatelliteMeasurement;
import com.huawei.riemann.gnsslocation.core.bean.sensor.MotionSensors;
import com.huawei.riemann.gnsslocation.core.yn;

public class VdrLocationClient {
    public static final String TAG = "com.huawei.riemann.gnsslocation.api.vdr.VdrLocationClient";
    public yn mVdrLocManager;

    public VdrLocationClient(Context context, String string) {
        if (context != null) {
            this.mVdrLocManager = new yn(context.getApplicationContext(), string);
            Log.i((String)TAG, (String)"VDR version time: 20211124");
        } else {
            try {
                throw new IllegalArgumentException("Context can not be null");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)TAG, (String)("vdr client error: " + illegalArgumentException.getMessage()));
            }
        }
    }

    public int startLocation(DeviceInfo deviceInfo) {
        Object object = ((VdrLocationClient)object).mVdrLocManager;
        if (object == null) {
            Log.e((String)TAG, (String)"start n");
            return -1;
        }
        if (((yn)object).FB) {
            Log.e((String)"VdrLocationManager", (String)"already started");
        } else {
            Object object2;
            ((yn)object).FB = true;
            object = "";
            FB fB = ((yn)object2).Vw;
            if (fB == null) {
                Log.v((String)"VdrLocationManager", (String)"lph is null");
            } else {
                fB.yn();
                Log.v((String)"LogPersistenceManager", (String)"log ph is null when start");
                object = "";
            }
            if (yn.yn != null && VdrLocationAlgoWrapper.FB) {
                yn.yn.vdrStart(deviceInfo, (String)object);
                Log.d((String)"VdrLocationManager", (String)("start vdr location finished, transPath: " + (String)object));
            } else {
                Log.e((String)"VdrLocationManager", (String)"start: wp is null");
            }
        }
        return 0;
    }

    public void stopLocation() {
        Object object = ((VdrLocationClient)object).mVdrLocManager;
        if (object == null) {
            Log.e((String)TAG, (String)"stop n");
            return;
        }
        if (!((yn)object).FB) {
            Log.e((String)"VdrLocationManager", (String)"already stopped");
        } else {
            ((yn)object).FB = false;
            if (yn.yn != null && VdrLocationAlgoWrapper.FB) {
                yn.yn.vdrStop();
                object = ((yn)object).Vw;
                if (object == null) {
                    Log.v((String)"VdrLocationManager", (String)"lpm is null");
                } else {
                    if (((FB)object).dC) {
                        ((FB)object).dC = false;
                        Object object2 = ((FB)object).LW;
                        if (object2 != null) {
                            object2.removeCallbacksAndMessages(null);
                        }
                        if ((object2 = ((FB)object).FB) != null) {
                            object2.quitSafely();
                        }
                        Object object3 = object;
                        ((FB)object3).LW = null;
                        ((FB)object3).FB = null;
                    }
                    Log.v((String)"LogPersistenceManager", (String)"log ph is null when stop");
                    Log.d((String)"VdrLocationManager", (String)"stop vdr location finished");
                }
            } else {
                Log.e((String)"VdrLocationManager", (String)"stop: wp is null");
            }
        }
    }

    public Pvt process(Pvt pvt, GnssRawObservation[] gnssRawObservationArray, MotionSensors motionSensors, Pvt pvt2) {
        yn yn2 = ((VdrLocationClient)((Object)yn2)).mVdrLocManager;
        if (yn2 == null) {
            Log.e((String)TAG, (String)"proc manager null");
            return pvt;
        }
        Log.d((String)"VdrLocationManager", (String)"vdr process start");
        if (pvt == null) {
            Log.w((String)"VdrLocationManager", (String)"pvt null in proc");
        }
        if (gnssRawObservationArray == null) {
            Log.w((String)"VdrLocationManager", (String)"obs null in proc");
        }
        if (motionSensors == null) {
            Log.e((String)"VdrLocationManager", (String)"sensors null in proc");
            pvt = null;
        } else if (yn.yn != null && VdrLocationAlgoWrapper.FB) {
            int n;
            int n2;
            GnssClock[] gnssClockArray = new GnssClock[]{};
            SatelliteMeasurement[] satelliteMeasurementArray = new SatelliteMeasurement[]{};
            if (gnssRawObservationArray != null) {
                gnssClockArray = new GnssClock[gnssRawObservationArray.length];
                satelliteMeasurementArray = new SatelliteMeasurement[gnssRawObservationArray.length];
                for (int i = 0; i < gnssRawObservationArray.length; ++i) {
                    if (gnssRawObservationArray[i] == null) {
                        Log.w((String)"VdrLocationManager", (String)("rawMeasurements[" + i + "] is null"));
                        continue;
                    }
                    gnssClockArray[i] = gnssRawObservationArray[i].getGnssClock();
                    satelliteMeasurementArray[i] = gnssRawObservationArray[i].getSatelliteMeasurement();
                }
            }
            yn2.LW = n2 = yn2.LW + 1;
            Log.d((String)"VdrLocationManager", (String)("vdr process algo start: " + n2));
            pvt = yn.yn.vdrProcess(pvt, gnssClockArray, satelliteMeasurementArray, motionSensors, pvt2);
            yn2.dC = n = yn2.dC + 1;
            Log.d((String)"VdrLocationManager", (String)("vdr process algo finished: " + n));
            if (yn2.Vw == null) {
                Log.v((String)"VdrLocationManager", (String)"lpm is null in proc");
            } else {
                Log.e((String)"LogPersistenceManager", (String)"log p helper null when proc");
            }
        } else {
            Log.e((String)"VdrLocationManager", (String)"wp is null in proc");
        }
        return pvt;
    }

    public void updateEphemeris(Ephemeris ephemeris) {
        if (((VdrLocationClient)((Object)yn2)).mVdrLocManager == null) {
            Log.e((String)TAG, (String)"no ephemeris data");
            return;
        }
        Log.d((String)TAG, (String)"updateEphemeris start");
        yn yn2 = ((VdrLocationClient)((Object)yn2)).mVdrLocManager;
        yn2.getClass();
        if (yn.yn != null && VdrLocationAlgoWrapper.FB) {
            yn.yn.vdrUpdateEphemeris(ephemeris);
            if (yn2.Vw == null) {
                Log.e((String)"VdrLocationManager", (String)"lpm is null");
            } else {
                Log.e((String)"LogPersistenceManager", (String)"log p helper null when eph");
                Log.d((String)"VdrLocationManager", (String)"update ephemeris finished");
            }
        } else {
            Log.e((String)"VdrLocationManager", (String)"update: wp is null");
        }
    }
}

