/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.huawei.hms.activity.IBridgeActivityDelegate;
import com.huawei.hms.api.BindingFailedResolveMgr;
import com.huawei.hms.api.FailedBinderCallBack;
import com.huawei.hms.common.internal.BindResolveClients;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.ui.AbstractDialog;
import com.huawei.hms.ui.AbstractPromptDialog;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.ResourceLoaderUtil;
import com.huawei.hms.utils.UIUtil;
import com.huawei.hms.utils.Util;

public class BindingFailedResolution
implements IBridgeActivityDelegate,
ServiceConnection {
    private static final String TAG = "BindingFailedResolution";
    private static final int REQUEST_CODE = 2003;
    private static final int MSG_CONN_TIMEOUT = 2;
    private static final int MSG_SELF_DESTROY_TIMEOUT = 3;
    private static final Object LOCK_CONNECT_TIMEOUT_HANDLER = new Object();
    private Activity curActivity;
    private boolean isStarting = true;
    private d promptdlg;
    private FailedBinderCallBack.BinderCallBack callBack;
    private Handler mConnectTimeoutHandler = null;
    private Handler selfDestroyHandler = null;

    private void selfDestroyHandle() {
        Handler handler = this.selfDestroyHandler;
        if (handler != null) {
            handler.removeMessages(3);
        } else {
            Handler.Callback callback;
            Handler handler2;
            handler = handler2;
            Looper looper = Looper.getMainLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    if (message != null && message.what == 3) {
                        a a2 = this;
                        HMSLog.i((String)BindingFailedResolution.TAG, (String)"selfDestroyHandle\uff1aMSG_SELF_DESTROY_TIMEOUT");
                        a2.BindingFailedResolution.this.noticeBindFailed();
                        a2.BindingFailedResolution.this.finishBridgeActivity(8);
                        return true;
                    }
                    return false;
                }
            };
            handler2 = new Handler(looper, callback2);
            this.selfDestroyHandler = handler;
        }
        this.selfDestroyHandler.sendEmptyMessageDelayed(3, 4000L);
    }

    private void tryStartHmsActivity(Activity activity) {
        Intent intent;
        String string = HMSPackageManager.getInstance((Context)activity.getApplicationContext()).getHMSPackageNameForMultiService();
        if (TextUtils.isEmpty((CharSequence)string)) {
            HMSLog.w((String)TAG, (String)"servicePackageName is empty, Service is invalid.");
            activity = this.selfDestroyHandler;
            if (activity != null) {
                activity.removeMessages(3);
                this.selfDestroyHandler = null;
            }
            this.bindCoreService(false);
            return;
        }
        Intent intent2 = intent;
        intent2();
        intent.putExtra("intent.extra.isfullscreen", UIUtil.isActivityFullscreen((Activity)activity));
        intent.setClassName(string, "com.huawei.hms.core.activity.JumpActivity");
        HMSLog.i((String)TAG, (String)"onBridgeActivityCreate\uff1atry to start HMS");
        try {
            activity.startActivityForResult(intent2, this.getRequestCode());
        }
        catch (Throwable throwable) {
            HMSLog.e((String)TAG, (String)("ActivityNotFoundException\uff1a" + throwable.getMessage()));
            Handler handler = this.selfDestroyHandler;
            if (handler != null) {
                handler.removeMessages(3);
                this.selfDestroyHandler = null;
            }
            this.bindCoreService(false);
        }
    }

    private void fireStartResult(boolean bl) {
        if (this.isStarting) {
            this.isStarting = false;
            this.onStartResult(bl);
        }
    }

    private void noticeBindFailed() {
        FailedBinderCallBack.BinderCallBack binderCallBack = ((BindingFailedResolution)((Object)binderCallBack)).callBack;
        if (binderCallBack != null) {
            binderCallBack.binderCallBack(8);
        }
    }

    private void noticeBindResult(boolean bl, int n) {
        if (bl && (this = ((BindingFailedResolution)this).callBack) != null) {
            this.binderCallBack(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void bindCoreService(boolean bl) {
        BindingFailedResolution bindingFailedResolution;
        BindingFailedResolution bindingFailedResolution2;
        Intent intent;
        Activity activity;
        String string;
        Intent intent2;
        Activity activity2 = this.getActivity();
        if (activity2 == null) {
            BindingFailedResolution bindingFailedResolution3 = this;
            HMSLog.e((String)TAG, (String)"In connect, bind core try fail");
            bindingFailedResolution3.fireStartResult(false);
            bindingFailedResolution3.noticeBindResult(bl, 8);
            return;
        }
        Intent intent3 = intent2;
        intent2 = new Intent(HMSPackageManager.getInstance((Context)activity2.getApplicationContext()).getServiceAction());
        try {
            string = HMSPackageManager.getInstance((Context)activity2.getApplicationContext()).getHMSPackageNameForMultiService();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BindingFailedResolution bindingFailedResolution4 = this;
            HMSLog.e((String)TAG, (String)"IllegalArgumentException when bindCoreService intent.setPackage");
            bindingFailedResolution4.fireStartResult(false);
            bindingFailedResolution4.noticeBindResult(bl, 8);
            return;
        }
        {
            if (TextUtils.isEmpty((CharSequence)string)) {
                HMSLog.e((String)TAG, (String)"servicePackageName is empty, Service is invalid.");
                this.fireStartResult(false);
                this.noticeBindResult(bl, 1);
                return;
            }
            activity = activity2;
            Intent intent4 = intent3;
            intent = intent4;
            intent4.setPackage(string);
        }
        Object object = LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            if (activity.bindService(intent, (ServiceConnection)this, 1)) {
                this.postConnDelayHandle();
                return;
            }
            BindingFailedResolution bindingFailedResolution5 = this;
            bindingFailedResolution2 = bindingFailedResolution5;
            bindingFailedResolution = bindingFailedResolution5;
        }
        HMSLog.e((String)TAG, (String)"In connect, bind core try fail");
        bindingFailedResolution2.fireStartResult(false);
        bindingFailedResolution.noticeBindResult(bl, 8);
    }

    private void finishBridgeActivity(int n) {
        Activity activity = bindingFailedResolution2.getActivity();
        if (activity != null && !activity.isFinishing()) {
            Intent intent;
            Activity activity2 = activity;
            BindingFailedResolution bindingFailedResolution = bindingFailedResolution2;
            HMSLog.i((String)TAG, (String)("finishBridgeActivity\uff1a" + n));
            BindingFailedResolution bindingFailedResolution2 = intent;
            new Intent().putExtra("intent.extra.RESULT", n);
            activity.setResult(-1, (Intent)bindingFailedResolution2);
            Util.unBindServiceCatchException((Context)activity2, bindingFailedResolution);
            activity2.finish();
            return;
        }
    }

    private void postConnDelayHandle() {
        Handler handler = this.mConnectTimeoutHandler;
        if (handler != null) {
            handler.removeMessages(2);
        } else {
            Handler.Callback callback;
            Handler handler2;
            handler = handler2;
            Looper looper = Looper.getMainLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    if (message != null && message.what == 2) {
                        HMSLog.e((String)BindingFailedResolution.TAG, (String)"In connect, bind core try timeout");
                        BindingFailedResolution.this.fireStartResult(false);
                        return true;
                    }
                    return false;
                }
            };
            handler2 = new Handler(looper, callback2);
            this.mConnectTimeoutHandler = handler;
        }
        this.mConnectTimeoutHandler.sendEmptyMessageDelayed(2, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelConnDelayHandle() {
        Object object = LOCK_CONNECT_TIMEOUT_HANDLER;
        synchronized (object) {
            Handler handler = this.mConnectTimeoutHandler;
            if (handler != null) {
                handler.removeMessages(2);
                this.mConnectTimeoutHandler = null;
            }
            return;
        }
    }

    private void showPromptdlg() {
        Object object = this.getActivity();
        if (object != null && !object.isFinishing()) {
            AbstractDialog.Callback callback;
            d d2 = this.promptdlg;
            if (d2 == null) {
                d d3;
                d2 = d3;
                d3 = new d();
                this.promptdlg = d2;
            } else {
                d2.dismiss();
            }
            HMSLog.i((String)TAG, (String)"showPromptdlg to resolve conn error");
            Activity activity = object;
            object = callback;
            callback = new AbstractDialog.Callback(){

                public void onDoWork(AbstractDialog abstractDialog) {
                    c c2 = this;
                    BindingFailedResolution.access$402(c2.BindingFailedResolution.this, null);
                    BindResolveClients.getInstance().unRegisterAll();
                    c2.BindingFailedResolution.this.finishBridgeActivity(8);
                }

                public void onCancel(AbstractDialog abstractDialog) {
                    c c2 = this;
                    BindingFailedResolution.access$402(c2.BindingFailedResolution.this, null);
                    BindResolveClients.getInstance().unRegisterAll();
                    c2.BindingFailedResolution.this.finishBridgeActivity(8);
                }
            };
            this.promptdlg.show(activity, (AbstractDialog.Callback)object);
            return;
        }
    }

    static /* synthetic */ d access$402(BindingFailedResolution bindingFailedResolution, d d2) {
        bindingFailedResolution.promptdlg = d2;
        return d2;
    }

    public void onBridgeActivityCreate(Activity activity) {
        if (activity == null) {
            HMSLog.e((String)TAG, (String)"activity is null");
            this.selfDestroyHandle();
            return;
        }
        if (activity.isFinishing()) {
            HMSLog.e((String)TAG, (String)"activity is finishing");
            return;
        }
        Intent intent = activity.getIntent();
        if (intent != null && intent.hasExtra("callId")) {
            long l = 0L;
            try {
                l = intent.getLongExtra("callId", 0L);
            }
            catch (Exception exception) {
                HMSLog.e((String)TAG, (String)("getExtras for callId exception:" + exception.getMessage()));
            }
            this.callBack = FailedBinderCallBack.getInstance().getCallBack(l);
        }
        this.curActivity = activity;
        BindingFailedResolveMgr.b.a(activity);
        this.selfDestroyHandle();
        this.tryStartHmsActivity(activity);
    }

    public void onBridgeActivityDestroy() {
        this.cancelConnDelayHandle();
        BindingFailedResolveMgr.b.b(this.curActivity);
        this.curActivity = null;
    }

    public boolean onBridgeActivityResult(int n, int n2, Intent intent) {
        if (n != this.getRequestCode()) {
            return false;
        }
        HMSLog.i((String)TAG, (String)"onBridgeActivityResult");
        Handler handler = this.selfDestroyHandler;
        if (handler != null) {
            handler.removeMessages(3);
            this.selfDestroyHandler = null;
        }
        this.bindCoreService(true);
        return true;
    }

    public void onBridgeConfigurationChanged() {
        if (this.promptdlg == null) {
            return;
        }
        HMSLog.i((String)TAG, (String)"re show prompt dialog");
        this.showPromptdlg();
    }

    public int getRequestCode() {
        return 2003;
    }

    public void onKeyUp(int n, KeyEvent keyEvent) {
        HMSLog.i((String)TAG, (String)"On key up when resolve conn error");
    }

    protected Activity getActivity() {
        return this.curActivity;
    }

    protected void onStartResult(boolean bl) {
        if (this.getActivity() == null) {
            return;
        }
        if (bl) {
            this.finishBridgeActivity(0);
            return;
        }
        this.showPromptdlg();
    }

    public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        BindingFailedResolution bindingFailedResolution = this;
        bindingFailedResolution.cancelConnDelayHandle();
        bindingFailedResolution.fireStartResult(true);
        if (bindingFailedResolution.getActivity() == null) {
            return;
        }
        HMSLog.i((String)TAG, (String)"test connect success, try to reConnect and reply message");
        BindResolveClients.getInstance().notifyClientReconnect();
    }

    public void onServiceDisconnected(ComponentName componentName) {
    }

    private static class d
    extends AbstractPromptDialog {
        private d() {
        }

        public String onGetMessageString(Context object) {
            Context context = object;
            Object object2 = Util.getAppName(context, null);
            object = Util.getAppName(context, HMSPackageManager.getInstance((Context)context).getHMSPackageNameForMultiService());
            String string = "hms_bindfaildlg_message";
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object2;
            int n = 1;
            if (TextUtils.isEmpty((CharSequence)object)) {
                object = "com.huawei.hwid";
            }
            objectArray2[n] = object;
            return ResourceLoaderUtil.getString((String)string, (Object[])objectArray2);
        }

        public String onGetPositiveButtonString(Context context) {
            return ResourceLoaderUtil.getString((String)"hms_confirm");
        }
    }
}

