/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.AndroidException;
import com.huawei.hms.android.HwBuildEx;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.support.common.ActivityMgr;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.Checker;
import com.huawei.hms.utils.HMSPackageManager;
import com.huawei.hms.utils.PackageManagerHelper;
import com.huawei.hms.utils.ReadApkFileUtil;

public abstract class HuaweiMobileServicesUtil {
    private static final String TAG = "HuaweiMobileServicesUtil";
    public static final String HMS_ERROR_DIALOG = "HuaweiMobileServicesErrorDialog";
    private static final int HMS_VERSION_CODE_NOMDM = 20500000;

    public static int isHuaweiMobileServicesAvailable(Context object, int n) {
        PackageManagerHelper packageManagerHelper;
        Checker.checkNonNull((Object)object, (String)"context must not be null.");
        if (Build.VERSION.SDK_INT < 16) {
            return 21;
        }
        if (HMSPackageManager.getInstance((Context)object).isUseOldCertificate()) {
            HMSLog.e((String)TAG, (String)"The CP uses the old certificate to terminate the connection.");
            return 13;
        }
        Object object2 = packageManagerHelper;
        packageManagerHelper = new PackageManagerHelper(object);
        String string = HMSPackageManager.getInstance((Context)object).getHMSPackageNameForMultiService();
        if (TextUtils.isEmpty((CharSequence)string)) {
            HMSLog.w((String)TAG, (String)"hmsPackageName is empty, Service is invalid.");
            return 1;
        }
        HMSLog.i((String)TAG, (String)("hmsPackageName is " + string));
        PackageManagerHelper.PackageStates packageStates = HMSPackageManager.getInstance((Context)object).getHMSPackageStatesForMultiService();
        if (PackageManagerHelper.PackageStates.NOT_INSTALLED.equals((Object)packageStates)) {
            HMSLog.w((String)TAG, (String)"HMS is not installed");
            return 1;
        }
        String string2 = ReadApkFileUtil.getHmsPath((Context)object);
        if (HwBuildEx.VERSION.EMUI_SDK_INT < 5 && object2.getPackageVersionCode(string) < 20500000 && ReadApkFileUtil.isCertFound((String)string2)) {
            object = object2.getPackageSignature(string);
            if (!("B92825C2BD5D6D6D1E7F39EECD17843B7D9016F611136B75441BC6F4D3F00F05".equalsIgnoreCase((String)object) || "3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object) || "3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object))) {
                return 9;
            }
            return 2;
        }
        if (PackageManagerHelper.PackageStates.SPOOF.equals((Object)packageStates)) {
            HMSLog.i((String)TAG, (String)"HMS is spoofed");
            return 9;
        }
        if (PackageManagerHelper.PackageStates.DISABLED.equals((Object)packageStates)) {
            HMSLog.i((String)TAG, (String)"HMS is disabled");
            return 3;
        }
        if (PackageManagerHelper.PackageStates.NOT_INSTALLED.equals((Object)packageStates) && !"B92825C2BD5D6D6D1E7F39EECD17843B7D9016F611136B75441BC6F4D3F00F05".equalsIgnoreCase((String)(object2 = object2.getPackageSignature(string))) && !"3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object2) && !"3517262215D8D3008CBF888750B6418EDC4D562AC33ED6874E0D73ABA667BC3C".equalsIgnoreCase((String)object2)) {
            return 9;
        }
        Object object3 = object;
        HMSLog.i((String)TAG, (String)("connect versionCode:" + HMSPackageManager.getInstance((Context)object3).getHmsMultiServiceVersion()));
        if (HMSPackageManager.getInstance((Context)object3).isApkUpdateNecessary(n)) {
            HMSLog.i((String)TAG, (String)"The current version does not meet the minimum version requirements");
            return 2;
        }
        return 0;
    }

    public static Resources getRemoteResource(Context context) {
        try {
            return context.getPackageManager().getResourcesForApplication(HuaweiMobileServicesUtil.getHMSPackageName(context));
        }
        catch (AndroidException androidException) {
            return null;
        }
    }

    private static String getHMSPackageName(Context object) {
        if (TextUtils.isEmpty((CharSequence)(object = HMSPackageManager.getInstance((Context)object).getHMSPackageName()))) {
            object = "com.huawei.hwid";
        }
        return object;
    }

    public static Context getRemoteContext(Context context) {
        try {
            Context context2 = context;
            return context2.createPackageContext(HuaweiMobileServicesUtil.getHMSPackageName(context2), 2);
        }
        catch (AndroidException androidException) {
            return null;
        }
    }

    public static Dialog getErrorDialog(int n, Activity activity, int n2) {
        return HuaweiApiAvailability.getInstance().getErrorDialog(activity, n, n2, null);
    }

    public static Dialog getErrorDialog(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().getErrorDialog(activity, n, n2, onCancelListener);
    }

    public static String getErrorString(int n) {
        return HuaweiApiAvailability.getInstance().getErrorString(n);
    }

    public static int isHuaweiMobileServicesAvailable(Context context) {
        return HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable(context);
    }

    public static boolean isUserRecoverableError(int n) {
        return HuaweiApiAvailability.getInstance().isUserResolvableError(n);
    }

    public static boolean popupErrDlgFragment(int n, Activity activity, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n, n2, onCancelListener);
    }

    public static boolean popupErrDlgFragment(int n, Activity activity, Fragment fragment, int n2, DialogInterface.OnCancelListener onCancelListener) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n, fragment, n2, onCancelListener);
    }

    public static boolean showErrorDialogFragment(int n, Activity activity, int n2) {
        return HuaweiApiAvailability.getInstance().showErrorDialogFragment(activity, n, n2, null);
    }

    public static void showErrorNotification(int n, Context context) {
        HuaweiApiAvailability.getInstance().showErrorNotification(context, n);
    }

    public static void setApplication(Application application) {
        ActivityMgr.INST.init(application);
    }

    @Deprecated
    public static String getOpenSourceSoftwareLicenseInfo(Context context) {
        return "";
    }
}

