/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.os.Bundle;
import com.huawei.hms.api.IPCCallback;
import com.huawei.hms.api.ProtocolNegotiate;
import com.huawei.hms.core.aidl.CodecLookup;
import com.huawei.hms.core.aidl.DataBuffer;
import com.huawei.hms.core.aidl.IAIDLCallback;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.core.aidl.MessageCodec;
import com.huawei.hms.core.aidl.RequestHeader;
import com.huawei.hms.support.api.client.AidlApiClient;
import com.huawei.hms.support.api.client.ApiClient;
import com.huawei.hms.support.api.client.InnerApiClient;
import com.huawei.hms.support.api.transport.DatagramTransport;
import com.huawei.hms.support.log.HMSLog;

public class IPCTransport
implements DatagramTransport {
    private static final String TAG = "IPCTransport";
    private final String mURI;
    private final IMessageEntity mEntity;
    private final Class<? extends IMessageEntity> mResponseClass;
    private int apiLevel;

    public IPCTransport(String string, IMessageEntity iMessageEntity, Class<? extends IMessageEntity> clazz) {
        this.mURI = string;
        this.mEntity = iMessageEntity;
        this.mResponseClass = clazz;
    }

    public IPCTransport(String string, IMessageEntity iMessageEntity, Class<? extends IMessageEntity> clazz, int n) {
        this.mURI = string;
        this.mEntity = iMessageEntity;
        this.mResponseClass = clazz;
        this.apiLevel = n;
    }

    private int syncCall(ApiClient apiClient, IAIDLCallback iAIDLCallback) {
        if (apiClient instanceof InnerApiClient) {
            DataBuffer dataBuffer;
            block9: {
                RequestHeader requestHeader;
                RequestHeader requestHeader2;
                DataBuffer dataBuffer2;
                dataBuffer = dataBuffer2;
                MessageCodec messageCodec = CodecLookup.find(new DataBuffer(((IPCTransport)((Object)aidlApiClient)).mURI, ProtocolNegotiate.getInstance().getVersion()).getProtocol());
                dataBuffer.addBody(messageCodec.encode(((IPCTransport)((Object)aidlApiClient)).mEntity, new Bundle()));
                RequestHeader requestHeader3 = requestHeader2 = requestHeader;
                requestHeader2();
                requestHeader2.setAppID(apiClient.getAppID());
                requestHeader3.setPackageName(apiClient.getPackageName());
                requestHeader3.setSdkVersion(61100302);
                requestHeader2.setApiNameList(((AidlApiClient)apiClient).getApiNameList());
                requestHeader2.setSessionId(apiClient.getSessionId());
                requestHeader.setApiLevel(((IPCTransport)((Object)aidlApiClient)).apiLevel);
                dataBuffer.header = messageCodec.encode(requestHeader, new Bundle());
                try {
                    AidlApiClient aidlApiClient = (AidlApiClient)apiClient;
                }
                catch (Exception exception) {
                    HMSLog.e((String)TAG, (String)("sync call ex:" + exception));
                    return 907135001;
                }
                if (aidlApiClient.getService() != null) break block9;
                HMSLog.e((String)TAG, (String)"HuaweiApiClient is not binded to service yet.");
                return 907135001;
            }
            aidlApiClient.getService().asyncCall(dataBuffer, iAIDLCallback);
            return 0;
        }
        if (apiClient instanceof AidlApiClient) {
            DataBuffer dataBuffer;
            AidlApiClient aidlApiClient = (AidlApiClient)apiClient;
            int n = ProtocolNegotiate.getInstance().getVersion();
            DataBuffer dataBuffer3 = dataBuffer;
            dataBuffer3.addBody(CodecLookup.find(new DataBuffer(((IPCTransport)((Object)aidlApiClient)).mURI, n).getProtocol()).encode(((IPCTransport)((Object)aidlApiClient)).mEntity, new Bundle()));
            try {
                aidlApiClient.getService().asyncCall(dataBuffer3, iAIDLCallback);
                return 0;
            }
            catch (Exception exception) {
                HMSLog.e((String)TAG, (String)("sync call ex:" + exception));
                return 907135001;
            }
        }
        return 907135001;
    }

    @Override
    public final void send(ApiClient object, DatagramTransport.a a2) {
        IPCCallback iPCCallback;
        ApiClient apiClient = object;
        object = iPCCallback;
        iPCCallback = new IPCCallback(this.mResponseClass, a2);
        int n = this.syncCall(apiClient, (IAIDLCallback)object);
        if (n != 0 && a2 != null) {
            a2.a(n, null);
        }
    }

    @Override
    public final void post(ApiClient apiClient, DatagramTransport.a a2) {
        this.send(apiClient, a2);
    }
}

