/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.api;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import com.huawei.hms.activity.IBridgeActivityDelegate;
import com.huawei.hms.activity.internal.BusResponseCallback;
import com.huawei.hms.activity.internal.ForegroundBusResponseMgr;
import com.huawei.hms.api.HuaweiApiAvailability;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.IntentUtil;
import java.lang.ref.WeakReference;

public class ResolutionDelegate
implements IBridgeActivityDelegate {
    public static final String CALLBACK_METHOD = "CALLBACK_METHOD";
    private static final String TAG = "ResolutionDelegate";
    private static final int REQUEST_CODE = 1002;
    private WeakReference<Activity> mThisWeakRef;

    private void finishBridgeActivity() {
        if ((this = this.getActivity()) != null && !this.isFinishing()) {
            this.finish();
            return;
        }
    }

    private Activity getActivity() {
        WeakReference<Activity> weakReference = ((ResolutionDelegate)((Object)weakReference)).mThisWeakRef;
        if (weakReference == null) {
            return null;
        }
        return (Activity)weakReference.get();
    }

    private BusResponseCallback getResponseCallback(String string) {
        return ForegroundBusResponseMgr.getInstance().get(string);
    }

    public void onBridgeActivityCreate(Activity activity) {
        if (activity != null && !activity.isFinishing()) {
            resolutionDelegate.mThisWeakRef = new WeakReference<Activity>(activity);
            ResolutionDelegate resolutionDelegate = null;
            try {
                resolutionDelegate = activity.getIntent().getExtras();
            }
            catch (Exception exception) {
                HMSLog.e((String)TAG, (String)("getExtras exception:" + exception.getMessage()));
            }
            if (resolutionDelegate != null) {
                activity.startActivityForResult(IntentUtil.modifyIntentBehaviorsSafe((Intent)((Intent)resolutionDelegate.getParcelable("resolution"))), 1002);
            }
            return;
        }
        HMSLog.e((String)TAG, (String)"activity is null or finishing");
    }

    public void onBridgeActivityDestroy() {
        this.mThisWeakRef = null;
    }

    public boolean onBridgeActivityResult(int n, int n2, Intent intent) {
        if (n != this.getRequestCode()) {
            return false;
        }
        ResolutionDelegate resolutionDelegate = this;
        BusResponseCallback busResponseCallback = resolutionDelegate.getResponseCallback(CALLBACK_METHOD);
        int n3 = HuaweiApiAvailability.getInstance().isHuaweiMobileServicesAvailable((Context)((Activity)resolutionDelegate.mThisWeakRef.get()), 30000000);
        if (n2 == -1 && n3 == 0) {
            HMSLog.i((String)TAG, (String)"Make service available success.");
        } else {
            busResponseCallback.innerError((Activity)this.mThisWeakRef.get(), n2, "Make service available failed.");
        }
        this.finishBridgeActivity();
        return true;
    }

    public void onBridgeConfigurationChanged() {
    }

    public int getRequestCode() {
        return 1002;
    }

    public void onKeyUp(int n, KeyEvent keyEvent) {
    }
}

