/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.huawei.hms.common.data.DataHolder;
import com.huawei.hms.common.internal.Objects;
import com.huawei.hms.common.internal.Preconditions;

public class DataBufferRef {
    protected final DataHolder mDataHolder;
    protected int mDataRow;
    private int a;

    public DataBufferRef(DataHolder dataHolder, int n) {
        Preconditions.checkNotNull((Object)dataHolder, (Object)"dataHolder cannot be null");
        this.mDataHolder = dataHolder;
        this.getWindowIndex(n);
    }

    protected int getDataRow() {
        return this.mDataRow;
    }

    protected final void getWindowIndex(int n) {
        Preconditions.checkArgument((n >= 0 && n < this.mDataHolder.getCount() ? 1 : 0) != 0, (Object)"rowNum is out of index");
        this.mDataRow = n;
        this.a = this.mDataHolder.getWindowIndex(n);
    }

    public boolean isDataValid() {
        return this.mDataHolder.isClosed() ^ true;
    }

    public boolean hasColumn(String string) {
        return this.mDataHolder.hasColumn(string);
    }

    protected long getLong(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_long");
        if (object != null) {
            return (Long)object;
        }
        return -1L;
    }

    protected int getInteger(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_int");
        if (object != null) {
            return (Integer)object;
        }
        return -1;
    }

    protected boolean getBoolean(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_boolean");
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    protected String getString(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_string");
        if (object != null) {
            return (String)object;
        }
        return "";
    }

    protected float getFloat(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_float");
        if (object != null) {
            return ((Float)object).floatValue();
        }
        return -1.0f;
    }

    protected double getDouble(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_double");
        if (object != null) {
            return (Double)object;
        }
        return -1.0;
    }

    protected byte[] getByteArray(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        Object object = this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_byte_array");
        if (object != null) {
            return (byte[])object;
        }
        return null;
    }

    protected Uri parseUri(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        String string2 = (String)this.mDataHolder.getValue(string, n, dataBufferRef.a, "type_string");
        if (string2 == null) {
            return null;
        }
        return Uri.parse((String)string2);
    }

    protected void copyToBuffer(String string, CharArrayBuffer charArrayBuffer) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        this.mDataHolder.copyToBuffer(string, n, dataBufferRef.a, charArrayBuffer);
    }

    protected boolean hasNull(String string) {
        DataBufferRef dataBufferRef = this;
        int n = dataBufferRef.mDataRow;
        return this.mDataHolder.hasNull(string, n, dataBufferRef.a);
    }

    public int hashCode() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mDataRow;
        objectArray2[1] = this.a;
        objectArray[2] = this.mDataHolder;
        return Objects.hashCode((Object[])objectArray);
    }

    public boolean equals(Object object) {
        if (object instanceof DataBufferRef) {
            object = (DataBufferRef)object;
            return ((DataBufferRef)object).mDataRow == this.mDataRow && ((DataBufferRef)object).a == this.a && ((DataBufferRef)object).mDataHolder == this.mDataHolder;
        }
        return false;
    }
}

