/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.data;

import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.Cursor;
import android.database.CursorWindow;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.data.DataHolderBuilderCreator;
import com.huawei.hms.common.data.DataHolderCreator;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.common.internal.safeparcel.AbstractSafeParcelable;
import com.huawei.hms.common.internal.safeparcel.SafeParcelWriter;
import com.huawei.hms.common.sqlite.HMSCursorWrapper;
import com.huawei.hms.support.log.HMSLog;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DataHolder
extends AbstractSafeParcelable
implements Closeable {
    private static final String TAG = "DataHolder";
    public static final Parcelable.Creator<DataHolder> CREATOR = new DataHolderCreator();
    public static final String TYPE_INT = "type_int";
    public static final String TYPE_LONG = "type_long";
    public static final String TYPE_STRING = "type_string";
    public static final String TYPE_BOOLEAN = "type_boolean";
    public static final String TYPE_FLOAT = "type_float";
    public static final String TYPE_DOUBLE = "type_double";
    public static final String TYPE_BYTE_ARRAY = "type_byte_array";
    private static final Builder BUILDER = new DataHolderBuilderCreator(new String[0], null);
    private boolean mClosed;
    private int version;
    private String[] columns;
    private Bundle columnsBundle;
    private CursorWindow[] cursorWindows;
    private int statusCode;
    private Bundle metadata;
    private int[] perCursorCounts;
    private int dataCount;
    private boolean isInstance;

    DataHolder(int n, String[] stringArray, CursorWindow[] cursorWindowArray, int n2, Bundle bundle) {
        DataHolder dataHolder = this;
        dataHolder.mClosed = false;
        dataHolder.isInstance = true;
        dataHolder.version = n;
        dataHolder.columns = stringArray;
        dataHolder.cursorWindows = cursorWindowArray;
        dataHolder.statusCode = n2;
        dataHolder.metadata = bundle;
        dataHolder.collectColumsAndCount();
    }

    public DataHolder(String[] stringArray, CursorWindow[] cursorWindowArray, int n, Bundle bundle) {
        Preconditions.checkNotNull((Object)stringArray, (Object)"columnsP cannot be null");
        Preconditions.checkNotNull((Object)cursorWindowArray, (Object)"cursorWindowP cannot be null");
        this.mClosed = false;
        this.isInstance = true;
        this.version = 1;
        this.columns = stringArray;
        this.cursorWindows = cursorWindowArray;
        this.statusCode = n;
        this.metadata = bundle;
        this.collectColumsAndCount();
    }

    private DataHolder(HMSCursorWrapper hMSCursorWrapper, int n, Bundle bundle) {
        String[] stringArray = stringArray2;
        HMSCursorWrapper hMSCursorWrapper2 = hMSCursorWrapper;
        String[] stringArray2 = hMSCursorWrapper2.getColumnNames();
        super(stringArray2, DataHolder.getCursorWindows(hMSCursorWrapper2), n, bundle);
    }

    public DataHolder(Cursor cursor, int n, Bundle bundle) {
        HMSCursorWrapper hMSCursorWrapper;
        DataHolder dataHolder = object;
        Object object = hMSCursorWrapper;
        hMSCursorWrapper = new HMSCursorWrapper(cursor);
        dataHolder((HMSCursorWrapper)((Object)object), n, bundle);
    }

    private DataHolder(Builder builder, int n, Bundle bundle) {
        String[] stringArray = stringArray2;
        Builder builder2 = builder;
        String[] stringArray2 = builder2.a;
        super(stringArray2, DataHolder.getCursorWindows(builder2, -1), n, null);
    }

    private DataHolder(Builder builder, int n, Bundle bundle, int n2) {
        String[] stringArray = stringArray2;
        Builder builder2 = builder;
        String[] stringArray2 = builder2.a;
        super(stringArray2, DataHolder.getCursorWindows(builder2, -1), n, bundle);
    }

    private static CursorWindow[] getCursorWindows(HMSCursorWrapper hMSCursorWrapper) {
        int n;
        int n2;
        ArrayList<CursorWindow> arrayList;
        block10: {
            ArrayList<CursorWindow> arrayList2;
            HMSCursorWrapper hMSCursorWrapper2 = hMSCursorWrapper;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<CursorWindow>();
            n2 = 0;
            try {
                n = hMSCursorWrapper2.getCount();
            }
            catch (Throwable throwable) {
                CursorWindow[] cursorWindowArray;
                try {
                    HMSLog.e((String)TAG, (String)("fail to getCursorWindows: " + throwable.getMessage()));
                    cursorWindowArray = new CursorWindow[]{};
                }
                catch (Throwable throwable2) {
                    hMSCursorWrapper.close();
                    throw throwable2;
                }
                hMSCursorWrapper.close();
                return cursorWindowArray;
            }
            CursorWindow cursorWindow = hMSCursorWrapper2.getWindow();
            if (cursorWindow == null) break block10;
            if (cursorWindow.getStartPosition() != 0) break block10;
            CursorWindow cursorWindow2 = cursorWindow;
            cursorWindow.acquireReference();
            hMSCursorWrapper.setWindow(null);
            arrayList.add(cursorWindow);
            n2 = cursorWindow2.getNumRows();
        }
        ArrayList<CursorWindow> arrayList3 = arrayList;
        ArrayList<CursorWindow> arrayList4 = arrayList3;
        ArrayList<CursorWindow> arrayList5 = arrayList3;
        arrayList3.addAll(DataHolder.iterCursorWrapper(hMSCursorWrapper, n2, n));
        CursorWindow[] cursorWindowArray = arrayList4.toArray(new CursorWindow[arrayList5.size()]);
        hMSCursorWrapper.close();
        return cursorWindowArray;
    }

    private static ArrayList<CursorWindow> iterCursorWrapper(HMSCursorWrapper hMSCursorWrapper, int n, int n2) {
        ArrayList<CursorWindow> arrayList;
        ArrayList<CursorWindow> arrayList2 = arrayList;
        arrayList = new ArrayList<CursorWindow>();
        while (n < n2 && hMSCursorWrapper.moveToPosition(n)) {
            CursorWindow cursorWindow = hMSCursorWrapper.getWindow();
            if (cursorWindow == null) {
                CursorWindow cursorWindow2;
                cursorWindow = cursorWindow2;
                new CursorWindow(null).setStartPosition(n);
                hMSCursorWrapper.fillWindow(n, cursorWindow);
            } else {
                cursorWindow.acquireReference();
                hMSCursorWrapper.setWindow(null);
            }
            if (cursorWindow.getNumRows() == 0) break;
            arrayList2.add(cursorWindow);
            n = cursorWindow.getNumRows() + cursorWindow.getStartPosition();
        }
        return arrayList2;
    }

    private static CursorWindow[] getCursorWindows(Builder builder, int n) {
        if (builder.a.length == 0) {
            return new CursorWindow[0];
        }
        if (n < 0 || n >= builder.b.size()) {
            n = builder.b.size();
        }
        ArrayList<CursorWindow> arrayList = DataHolder.iterCursorWindow(builder, n, builder.b.subList(0, n));
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private static ArrayList<CursorWindow> iterCursorWindow(Builder builder, int n, List list) {
        CursorWindow cursorWindow;
        ArrayList<CursorWindow> arrayList;
        ArrayList<CursorWindow> arrayList2 = arrayList;
        arrayList = new ArrayList<CursorWindow>();
        CursorWindow cursorWindow2 = cursorWindow;
        cursorWindow2(null);
        cursorWindow.setNumColumns(builder.a.length);
        arrayList.add(cursorWindow);
        for (int i = 0; i < n; ++i) {
            Object object;
            block15: {
                CursorWindow cursorWindow3;
                void var4_5;
                block14: {
                    CursorWindow cursorWindow4;
                    if (var4_5.allocRow()) break block14;
                    HMSLog.d((String)TAG, (String)"Failed to allocate a row");
                    object = cursorWindow4;
                    Builder builder2 = builder;
                    Object object2 = object;
                    int n2 = i;
                    object(null);
                    object2.setStartPosition(n2);
                    cursorWindow4.setNumColumns(builder2.a.length);
                    try {
                        if (!cursorWindow4.allocRow()) {
                            HMSLog.e((String)TAG, (String)"Failed to retry to allocate a row");
                            return arrayList2;
                        }
                        arrayList2.add((CursorWindow)object);
                    }
                    catch (RuntimeException runtimeException) {
                        Object object3 = object;
                    }
                    Object object4 = object;
                    break block14;
                    break block15;
                }
                try {
                    object = (HashMap)list.get(i);
                    boolean bl = true;
                    for (int j = 0; j < builder.a.length && (bl = DataHolder.putValue((CursorWindow)var4_5, object.get(builder.a[j]), i, j)); ++j) {
                    }
                    if (bl) continue;
                }
                catch (RuntimeException runtimeException) {}
                ArrayList<CursorWindow> arrayList3 = arrayList2;
                HMSLog.d((String)TAG, (String)("fail to put data for row " + i));
                var4_5.freeLastRow();
                object = cursorWindow3;
                object(null);
                object.setStartPosition(i);
                cursorWindow3.setNumColumns(builder.a.length);
                arrayList3.add(cursorWindow3);
                break;
            }
            object = arrayList2.iterator();
            while (object.hasNext()) {
                ((CursorWindow)object.next()).close();
            }
            HMSLog.w((String)TAG, (String)"iter CursorWindow failed, RuntimeException occured.");
        }
        return arrayList2;
    }

    private static boolean putValue(CursorWindow cursorWindow, Object object, int n, int n2) throws IllegalArgumentException {
        if (object == null) {
            return cursorWindow.putNull(n, n2);
        }
        if (object instanceof Boolean) {
            long l = (Boolean)object != false ? 1L : 0L;
            return cursorWindow.putLong(l, n, n2);
        }
        if (object instanceof Integer) {
            return cursorWindow.putLong((long)((Integer)object).intValue(), n, n2);
        }
        if (object instanceof Long) {
            return cursorWindow.putLong(((Long)object).longValue(), n, n2);
        }
        if (object instanceof Float) {
            return cursorWindow.putDouble((double)((Float)object).floatValue(), n, n2);
        }
        if (object instanceof Double) {
            return cursorWindow.putDouble(((Double)object).doubleValue(), n, n2);
        }
        if (object instanceof String) {
            return cursorWindow.putString((String)object, n, n2);
        }
        if (object instanceof byte[]) {
            return cursorWindow.putBlob((byte[])object, n, n2);
        }
        throw new IllegalArgumentException("unsupported type for column: " + object);
    }

    private void checkAvailable(String string, int n) {
        String string2 = "";
        Bundle bundle = this.columnsBundle;
        if (bundle != null && bundle.containsKey(string)) {
            if (this.isClosed()) {
                string2 = "buffer has been closed";
            } else if (n < 0 || n >= this.dataCount) {
                string2 = "row is out of index:" + n;
            }
        } else {
            string2 = "cannot find column: " + string;
        }
        Preconditions.checkArgument((boolean)string2.isEmpty(), (Object)string2);
    }

    public static Builder builder(String[] stringArray) {
        return new Builder(stringArray, null);
    }

    public static DataHolder empty(int n) {
        return new DataHolder(BUILDER, n, null);
    }

    public final void collectColumsAndCount() {
        String[] stringArray;
        DataHolder dataHolder = this;
        String[] stringArray2 = stringArray;
        stringArray = new Bundle();
        dataHolder.columnsBundle = stringArray2;
        stringArray2 = dataHolder.columns;
        if (dataHolder.columns != null && stringArray2.length != 0) {
            String[] stringArray3;
            int n = 0;
            while (true) {
                stringArray3 = this.columns;
                if (n >= this.columns.length) break;
                this.columnsBundle.putInt(stringArray3[n], n);
                ++n;
            }
            n = 0;
            stringArray3 = this.cursorWindows;
            if (this.cursorWindows != null && stringArray3.length != 0) {
                this.perCursorCounts = new int[stringArray3.length];
                int n2 = 0;
                while (true) {
                    CursorWindow[] cursorWindowArray = this.cursorWindows;
                    if (n2 >= this.cursorWindows.length) break;
                    this.perCursorCounts[n2] = n;
                    n = cursorWindowArray[n2].getStartPosition() + this.cursorWindows[n2].getNumRows();
                    ++n2;
                }
                this.dataCount = n;
                return;
            }
            this.dataCount = 0;
            return;
        }
        this.dataCount = 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        if (parcel == null) {
            return;
        }
        Parcel parcel2 = parcel;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeStringArray(parcel, 1, this.columns, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel, (int)2, (Parcelable[])this.cursorWindows, (int)n, (boolean)false);
        SafeParcelWriter.writeInt(parcel, 3, this.getStatusCode());
        SafeParcelWriter.writeBundle(parcel, 4, this.getMetadata(), false);
        SafeParcelWriter.writeInt(parcel2, 1000, this.version);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
        if ((n & 1) != 0) {
            this.close();
        }
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final Bundle getMetadata() {
        return this.metadata;
    }

    public final boolean hasColumn(String string) {
        return this.columnsBundle.containsKey(string);
    }

    public final Object getValue(String string, int n, int n2, String string2) {
        String string3 = string2;
        string3.hashCode();
        int n3 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1300508295: {
                if (!string2.equals(TYPE_BYTE_ARRAY)) break;
                n3 = 6;
                break;
            }
            case 878975158: {
                if (!string2.equals(TYPE_STRING)) break;
                n3 = 5;
                break;
            }
            case 519136353: {
                if (!string2.equals(TYPE_LONG)) break;
                n3 = 4;
                break;
            }
            case 445002870: {
                if (!string2.equals(TYPE_DOUBLE)) break;
                n3 = 3;
                break;
            }
            case -675993238: {
                if (!string2.equals(TYPE_INT)) break;
                n3 = 2;
                break;
            }
            case -870070237: {
                if (!string2.equals(TYPE_BOOLEAN)) break;
                n3 = 1;
                break;
            }
            case -1092271849: {
                if (!string2.equals(TYPE_FLOAT)) break;
                n3 = 0;
            }
        }
        switch (n3) {
            default: {
                return null;
            }
            case 6: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getBlob(n, this.columnsBundle.getInt(string));
            }
            case 5: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getString(n, this.columnsBundle.getInt(string));
            }
            case 4: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getLong(n, this.columnsBundle.getInt(string));
            }
            case 3: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getDouble(n, this.columnsBundle.getInt(string));
            }
            case 2: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getInt(n, this.columnsBundle.getInt(string));
            }
            case 1: {
                DataHolder dataHolder = this;
                dataHolder.checkAvailable(string, n);
                return dataHolder.cursorWindows[n2].getLong(n, this.columnsBundle.getInt(string)) == 1L;
            }
            case 0: 
        }
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string, n);
        return Float.valueOf(dataHolder.cursorWindows[n2].getFloat(n, this.columnsBundle.getInt(string)));
    }

    public final void copyToBuffer(String string, int n, int n2, CharArrayBuffer charArrayBuffer) {
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string, n);
        dataHolder.cursorWindows[n2].copyStringToBuffer(n, this.columnsBundle.getInt(string), charArrayBuffer);
    }

    public final boolean hasNull(String string, int n, int n2) {
        DataHolder dataHolder = this;
        dataHolder.checkAvailable(string, n);
        return dataHolder.cursorWindows[n2].getType(n, this.columnsBundle.getInt(string)) == 0;
    }

    public final int getCount() {
        return this.dataCount;
    }

    public final int getWindowIndex(int n) {
        int[] nArray;
        Preconditions.checkArgument((n >= 0 || n < this.dataCount ? 1 : 0) != 0, (Object)("rowIndex is out of index:" + n));
        int n2 = 0;
        while (true) {
            nArray = this.perCursorCounts;
            if (n2 >= this.perCursorCounts.length) break;
            if (n < nArray[n2]) {
                --n2;
                break;
            }
            ++n2;
        }
        if (n2 == nArray.length) {
            --n2;
        }
        return n2;
    }

    public final synchronized boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public final synchronized void close() {
        if (!this.mClosed) {
            CursorWindow[] cursorWindowArray = this.cursorWindows;
            int n = this.cursorWindows.length;
            for (int i = 0; i < n; ++i) {
                cursorWindowArray[i].close();
            }
            this.mClosed = true;
        }
    }

    protected final void finalize() throws Throwable {
        if (this.isInstance && this.cursorWindows.length > 0 && !this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    public static class DataHolderException
    extends RuntimeException {
        public DataHolderException(String string) {
            super(string);
        }
    }

    public static class Builder {
        private String[] a;
        private final ArrayList<HashMap<String, Object>> b;
        private final String c;
        private final HashMap<Object, Integer> d;

        private Builder(String[] stringArray, String string) {
            HashMap hashMap;
            ArrayList arrayList;
            Builder builder = object;
            Preconditions.checkNotNull((Object)stringArray, (Object)"builderColumnsP cannot be null");
            builder.a = stringArray;
            Object object = arrayList;
            arrayList = new ArrayList();
            builder.b = object;
            builder.c = string;
            object = hashMap;
            hashMap = new HashMap();
            builder.d = object;
        }

        Builder(String[] stringArray, String string, DataHolderBuilderCreator dataHolderBuilderCreator) {
            this(stringArray, null);
        }

        public Builder setDataForContentValuesHashMap(HashMap<String, Object> hashMap) {
            Preconditions.checkNotNull(hashMap, (Object)"contentValuesHashMap cannot be null");
            int n = 0;
            boolean bl = false;
            Object object = this.c;
            if (object != null && (object = hashMap.get(object)) != null) {
                Integer n2 = this.d.get(object);
                if (n2 != null) {
                    n = n2;
                    bl = true;
                } else {
                    this.d.put(object, this.b.size());
                }
            }
            if (bl) {
                Builder builder = this;
                builder.b.remove(n);
                builder.b.add(n, hashMap);
            } else {
                this.b.add(hashMap);
            }
            return this;
        }

        public Builder withRow(ContentValues object) {
            HashMap<String, Object> hashMap;
            ContentValues contentValues = object;
            Preconditions.checkNotNull((Object)contentValues, (Object)"contentValues cannot be null");
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>(object.size());
            for (Map.Entry entry : contentValues.valueSet()) {
                Object k = entry.getKey();
                hashMap2.put((String)k, entry.getValue());
            }
            return this.setDataForContentValuesHashMap(hashMap2);
        }

        public DataHolder build(int n) {
            return new DataHolder(this, n, null);
        }

        public DataHolder build(int n, Bundle bundle) {
            return new DataHolder(this, n, bundle, -1);
        }
    }
}

