/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.common.internal.safeparcel;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.hms.common.internal.Preconditions;
import com.huawei.hms.common.internal.safeparcel.SafeParcelable;
import com.huawei.hms.common.util.Base64Utils;
import java.util.ArrayList;
import java.util.Iterator;

public final class SafeParcelableSerializer {
    public static <S extends SafeParcelable> byte[] serializeToBytes(S s) {
        Parcel parcel = Parcel.obtain();
        if (s != null) {
            s.writeToParcel(parcel, 0);
        }
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    public static <S extends SafeParcelable> S deserializeFromBytes(byte[] byArray, Parcelable.Creator<S> parcel) {
        Parcel parcel2 = parcel;
        Preconditions.checkNotNull(parcel2);
        parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)parcel2.createFromParcel(parcel);
        parcel.recycle();
        return (S)safeParcelable;
    }

    public static <S extends SafeParcelable> void serializeIterableToBundle(Iterable<S> arrayList, Bundle bundle, String string) {
        if (arrayList != null && bundle != null) {
            ArrayList<byte[]> arrayList2;
            ArrayList<byte[]> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<byte[]>();
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)iterator.next()));
            }
            bundle.putSerializable(string, arrayList);
            return;
        }
    }

    public static <S extends SafeParcelable> ArrayList<S> deserializeIterableFromBundle(Bundle object, String object2, Parcelable.Creator<S> creator) {
        ArrayList arrayList;
        if (object == null) {
            return null;
        }
        if ((object = (ArrayList)object.getSerializable((String)object2)) == null) {
            return null;
        }
        object2 = arrayList;
        arrayList = new ArrayList(((ArrayList)object).size());
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ((ArrayList)object2).add(SafeParcelableSerializer.deserializeFromBytes((byte[])object.next(), creator));
        }
        return object2;
    }

    public static <S extends SafeParcelable> String serializeToString(S s) {
        return Base64Utils.encodeUrlSafe(SafeParcelableSerializer.serializeToBytes(s));
    }

    public static <S extends SafeParcelable> S deserializeFromString(String string, Parcelable.Creator<S> creator) {
        return SafeParcelableSerializer.deserializeFromBytes(Base64Utils.decodeUrlSafe(string), creator);
    }

    public static <S extends SafeParcelable> void serializeToIntentExtra(S s, Intent intent, String string) {
        if (s != null && intent != null) {
            intent.putExtra(string, SafeParcelableSerializer.serializeToBytes(s));
            return;
        }
    }

    public static <S extends SafeParcelable> S deserializeFromIntentExtra(Intent object, String string, Parcelable.Creator<S> creator) {
        if (object == null) {
            return null;
        }
        byte[] byArray = object.getByteArrayExtra(string);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return SafeParcelableSerializer.deserializeFromBytes((byte[])object, creator);
    }

    public static <S extends SafeParcelable> void serializeIterableToIntentExtra(Iterable<S> arrayList, Intent intent, String string) {
        if (arrayList != null && intent != null) {
            ArrayList<byte[]> arrayList2;
            ArrayList<byte[]> arrayList3 = arrayList;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<byte[]>();
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)iterator.next()));
            }
            intent.putExtra(string, arrayList);
            return;
        }
    }

    public static <S extends SafeParcelable> ArrayList<S> deserializeIterableFromIntentExtra(Intent object, String object2, Parcelable.Creator<S> creator) {
        ArrayList arrayList;
        if (object == null) {
            return null;
        }
        if ((object = (ArrayList)object.getSerializableExtra((String)object2)) == null) {
            return null;
        }
        object2 = arrayList;
        arrayList = new ArrayList(((ArrayList)object).size());
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            ((ArrayList)object2).add(SafeParcelableSerializer.deserializeFromBytes((byte[])object.next(), creator));
        }
        return object2;
    }
}

