/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import com.huawei.hms.support.common.ActivityMgr;
import com.huawei.hms.support.log.HMSLog;

public class UIUtil {
    public static boolean isActivityFullscreen(Activity activity) {
        if (activity == null) {
            HMSLog.w((String)"UIUtil", (String)"activity is null");
            return false;
        }
        return (activity.getWindow().getAttributes().flags & 0x400) == 1024;
    }

    public static Activity getActiveActivity(Activity activity, Context context) {
        if (UIUtil.isBackground(context)) {
            HMSLog.i((String)"UIUtil", (String)("isBackground" + UIUtil.isBackground(context)));
            return null;
        }
        if (activity == null) {
            HMSLog.i((String)"UIUtil", (String)"activity is null");
            return ActivityMgr.INST.getCurrentActivity();
        }
        if (activity.isFinishing()) {
            HMSLog.i((String)"UIUtil", (String)("activity isFinishing is " + activity.isFinishing()));
            return ActivityMgr.INST.getCurrentActivity();
        }
        return activity;
    }

    public static boolean isBackground(Context object) {
        if (object == null) {
            return true;
        }
        Object object2 = (ActivityManager)object.getSystemService("activity");
        KeyguardManager keyguardManager = (KeyguardManager)object.getSystemService("keyguard");
        if (object2 != null && keyguardManager != null) {
            if ((object2 = object2.getRunningAppProcesses()) == null) {
                return true;
            }
            object = UIUtil.getProcessName(object, Process.myPid());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object2.next();
                if (!TextUtils.equals((CharSequence)runningAppProcessInfo.processName, (CharSequence)object)) continue;
                HMSLog.i((String)"UIUtil", (String)("appProcess.importance is " + runningAppProcessInfo.importance));
                boolean bl = runningAppProcessInfo.importance == 100;
                boolean bl2 = keyguardManager.isKeyguardLocked();
                HMSLog.i((String)"UIUtil", (String)("isForground is " + bl + "***  isLockedState is " + bl2));
                return !bl || bl2;
            }
            return true;
        }
        return true;
    }

    public static String getProcessName(Context object, int n) {
        if (object == null) {
            return "";
        }
        if ((object = (ActivityManager)object.getSystemService("activity")) != null && (object = object.getRunningAppProcesses()) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)object.next();
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return "";
    }

    private static int a(Context context) {
        if (context == null) {
            return 0;
        }
        return context.getResources().getIdentifier("androidhwext:style/Theme.Emui", null, null);
    }

    public static int getDialogThemeId(Activity activity) {
        if (UIUtil.a((Context)activity) != 0 && Build.VERSION.SDK_INT >= 16) {
            return 0;
        }
        if (activity == null) {
            return 3;
        }
        if ((activity.getResources().getConfiguration().uiMode & 0x30) == 32) {
            return 2;
        }
        return 3;
    }

    public static Intent modifyIntentBehaviorsSafe(Intent intent) {
        if (intent == null) {
            return null;
        }
        String string = intent.getAction();
        if ("android.intent.action.SEND".equals(string) || "android.intent.action.SEND_MULTIPLE".equals(string) || "android.media.action.IMAGE_CAPTURE".equals(string) || "android.media.action.IMAGE_CAPTURE_SECURE".equals(string) || "android.media.action.VIDEO_CAPTURE".equals(string)) {
            intent.setAction("android.intent.action.VIEW");
        }
        int n = intent.getFlags();
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 21) {
            n &= 0xFFFFFF7F;
        }
        if (n2 >= 19) {
            n &= 0xFFFFFFBF;
        }
        Intent intent2 = intent;
        intent2.setFlags(n & 0xFFFFFFFE & 0xFFFFFFFD);
        return intent2;
    }
}

