/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.location.common;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import com.huawei.hmf.tasks.OnFailureListener;
import com.huawei.hmf.tasks.OnSuccessListener;
import com.huawei.hmf.tasks.Task;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.location.FusedLocationProviderClient;
import com.huawei.hms.location.LocationAvailability;
import com.huawei.hms.location.LocationCallback;
import com.huawei.hms.location.LocationRequest;
import com.huawei.hms.location.LocationServices;
import com.huawei.hms.locationSdk.j0;
import com.huawei.hms.locationSdk.k0;
import com.huawei.hms.support.api.location.common.CollectionsUtil;
import com.huawei.hms.support.api.location.common.HMSLocationLog;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.location.lite.common.android.context.ContextUtil;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LocationClientStateManager {
    public static final int RE_START_STATE_INITIAL = 0;
    public static final int RE_START_STATE_DOING = 1;
    public static final int RE_START_STATE_FAILED = 2;
    private static final String TAG = "LocationClientStateManager";
    private static final long MAX_INTERVAL_TIME = 300000L;
    private static final long REPEAT_REQUEST_INTERVAL_TIME = 500L;
    private static final int MAX_RECONNECT_COUNT = 3;
    private static final int INTERNAL_ERROR = 10000;
    private static final int PERMISSION_DENIED = 10102;
    private static final int CP_PERMISSION_DENIED = 10803;
    private static final int MSG_RESTART = 1001;
    private static final int MSG_RESTART_DELAY_CHECK = 1002;
    private static final int DELAY_TIME = 300;
    private static final int DELAY_MSG_CHECK_TIME = 12000;
    private static final String IS_RE_REQUEST = "isReRequest";
    private static final String LOCATIONAVAILABILITY_EXTRA_KEY = "com.huawei.hms.location.EXTRA_LOCATION_AVAILABILITY";
    private volatile AtomicLong lastDisConnectTime;
    private volatile AtomicInteger reConnectCount;
    private volatile AtomicInteger resendState;
    private Handler handler;

    private LocationClientStateManager() {
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        AtomicLong atomicLong;
        Object object = atomicLong;
        atomicLong = new AtomicLong(0L);
        v1.lastDisConnectTime = object;
        object = atomicInteger2;
        atomicInteger2 = new AtomicInteger(0);
        v1.reConnectCount = object;
        object = atomicInteger;
        atomicInteger = new AtomicInteger(0);
        v1.resendState = object;
    }

    public static LocationClientStateManager getInstance() {
        return d.a;
    }

    private boolean checkReconnectStrategy() {
        long l2 = SystemClock.elapsedRealtime();
        if (l2 - this.lastDisConnectTime.get() < 500L) {
            HMSLog.e((String)TAG, (String)"can not reconnect , not satisfied interval");
            return false;
        }
        if (this.reConnectCount.get() == 0) {
            LocationClientStateManager locationClientStateManager = this;
            locationClientStateManager.lastDisConnectTime.set(l2);
            locationClientStateManager.reConnectCount.incrementAndGet();
            HMSLog.i((String)TAG, (String)"first reconnect");
            return true;
        }
        if (l2 - this.lastDisConnectTime.get() > 300000L) {
            LocationClientStateManager locationClientStateManager = this;
            locationClientStateManager.reConnectCount.set(1);
            locationClientStateManager.lastDisConnectTime.set(l2);
            HMSLog.i((String)TAG, (String)"over MAX_INTERVAL_TIME , restart first reconnect");
            return true;
        }
        if (this.reConnectCount.get() >= 3) {
            this.lastDisConnectTime.set(l2);
            HMSLog.i((String)TAG, (String)"can not reconnect , cause count > MAX_RECONNECT_COUNT");
            return false;
        }
        LocationClientStateManager locationClientStateManager = this;
        HMSLog.i((String)TAG, (String)"can reconnect");
        locationClientStateManager.lastDisConnectTime.set(l2);
        locationClientStateManager.reConnectCount.incrementAndGet();
        return true;
    }

    private boolean canResendRequest() {
        return this.resendState.get() == 2 || this.resendState.get() == 0;
    }

    private boolean checkCanResendRequest() {
        return this.checkReconnectStrategy() && this.canResendRequest();
    }

    private void setResendState(int n2) {
        this.resendState.set(n2);
    }

    private void reSendRequest() {
        Iterator iterator;
        Object object;
        block10: {
            object = j0.b().a();
            if (!CollectionsUtil.isEmpty(object)) break block10;
            HMSLog.i((String)TAG, (String)"onConnected, requests cache list is empty remove delay check msg");
            this.handler.removeMessages(1002);
            LocationClientStateManager.getInstance().setResendState(0);
            return;
        }
        List list = object;
        HMSLog.i((String)TAG, (String)("request cache list size:" + object.size()));
        object = LocationServices.getFusedLocationProviderClient(ContextUtil.getContext());
        try {
            iterator = list.iterator();
        }
        catch (Exception exception) {
            LocationClientStateManager.getInstance().setResendState(2);
            HMSLog.e((String)TAG, (String)"onConnected exception");
        }
        while (true) {
            if (!iterator.hasNext()) break;
            LocationClientStateManager locationClientStateManager = this;
            Object object2 = object;
            k0 k02 = (k0)iterator.next();
            HMSLocationLog.i(TAG, k02.a(), "onConnected, request in cache list prepare to send");
            locationClientStateManager.realRequest((FusedLocationProviderClient)object2, k02);
            continue;
            break;
        }
    }

    private void realRequest(FusedLocationProviderClient fusedLocationProviderClient, k0 k02) {
        k0 k03 = k02;
        LocationCallback locationCallback = k03.c();
        LocationRequest locationRequest = k03.d();
        PendingIntent pendingIntent = k02.b();
        if (locationRequest == null) {
            LocationClientStateManager.getInstance().setResendState(0);
            HMSLocationLog.w(TAG, k02.a(), "onConnected, requests cache list param is error");
            return;
        }
        locationRequest.putExtras(IS_RE_REQUEST, "1");
        if (locationCallback != null) {
            if (TextUtils.equals((CharSequence)k02.f(), (CharSequence)"ExCallback")) {
                k0 k04 = k02;
                HMSLocationLog.i(TAG, k04.a(), "send ex location request");
                this.addListener(fusedLocationProviderClient.requestLocationUpdatesEx(locationRequest, locationCallback, k04.e()), locationCallback, null);
            } else {
                k0 k05 = k02;
                HMSLocationLog.i(TAG, k05.a(), "send location request");
                this.addListener(fusedLocationProviderClient.requestLocationUpdates(locationRequest, locationCallback, k05.e()), locationCallback, null);
            }
        } else if (pendingIntent != null) {
            this.addListener(fusedLocationProviderClient.requestLocationUpdates(locationRequest, pendingIntent), null, pendingIntent);
        } else {
            LocationClientStateManager.getInstance().setResendState(0);
            HMSLocationLog.w(TAG, k02.a(), "onConnected, requests cache list param is error");
        }
    }

    private void addListener(Task<Void> task, final LocationCallback locationCallback, final PendingIntent pendingIntent) {
        task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                HMSLog.i((String)LocationClientStateManager.TAG, (String)"task request onSuccess");
                LocationClientStateManager.this.handler.removeMessages(1002);
                LocationClientStateManager.getInstance().setResendState(0);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(Exception exception) {
                a a2 = locationCallback2;
                HMSLog.e((String)LocationClientStateManager.TAG, (String)"task request onFailure");
                a2.LocationClientStateManager.this.handler.removeMessages(1002);
                a a3 = locationCallback2;
                LocationCallback locationCallback2 = a3.locationCallback;
                a2.LocationClientStateManager.this.handlerOnFailureMsg(exception, locationCallback2, a3.pendingIntent);
                LocationClientStateManager.getInstance().setResendState(2);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private void handlerOnFailureMsg(Exception var1_1, LocationCallback var2_2, PendingIntent var3_3) {
        block14: {
            block13: {
                if (!(var1_1 instanceof ApiException)) ** GOTO lbl37
                var1_1 = (ApiException)var1_1;
                var4_4 = var1_1.getStatusCode();
                if (var4_4 == 10000 || var4_4 == 10102 || var4_4 == 10803) break block13;
                if (var4_4 != 907135004) break block14;
                HMSLog.e((String)"LocationClientStateManager", (String)"task request onFailure from HMS and checkRestart");
                this.checkCanResend();
            }
            if (var2_2 != null) {
                v0 = new LocationAvailability();
                v0.setLocationStatus(1001);
                var2_2.onLocationAvailability(v0);
                HMSLog.e((String)"LocationClientStateManager", (String)("task request onFailure from Location and callback to cp ,errorCode " + var1_1.getStatusCode()));
            }
            if (var3_3 == null) break block14;
            v1 = var3_3;
            this = v2;
            v2 = new Intent();
            var2_2 = v3;
            new LocationAvailability().setLocationStatus(1001);
            v2.putExtra("com.huawei.hms.location.EXTRA_LOCATION_AVAILABILITY", (Parcelable)var2_2);
            v1.send(ContextUtil.getContext(), 0, (Intent)this);
            try {
                HMSLog.e((String)"LocationClientStateManager", (String)("task request onFailure from Location and pendingIntent to cp ,errorCode " + var1_1.getStatusCode()));
                break block14;
lbl37:
                // 1 sources

                HMSLog.e((String)"LocationClientStateManager", (String)"handlerOnFailureMsg failed by instanceof failed");
            }
            catch (Exception v4) {
                HMSLog.e((String)"LocationClientStateManager", (String)"handlerOnFailureMsg failed by exception");
            }
        }
    }

    private void checkReSendState() {
        if (LocationClientStateManager.getInstance().getResendState() == 1) {
            LocationClientStateManager.getInstance().setResendState(2);
            HMSLog.e((String)TAG, (String)"reSend request time out ,reset state to RE_START_STATE_FAILED");
        }
    }

    private void initHandler() {
        if (this.handler == null) {
            Handler.Callback callback;
            Handler handler;
            HandlerThread handlerThread;
            HandlerThread handlerThread2 = handlerThread;
            new HandlerThread(TAG).start();
            Handler handler2 = handler;
            handlerThread2 = handlerThread2.getLooper();
            Handler.Callback callback2 = callback;
            callback = new Handler.Callback(){

                public boolean handleMessage(Message message) {
                    int n2 = message.what;
                    if (n2 != 1001) {
                        if (n2 == 1002) {
                            LocationClientStateManager.this.checkReSendState();
                        }
                    } else {
                        c c2 = this;
                        c2.LocationClientStateManager.this.handler.removeMessages(1002);
                        c2.LocationClientStateManager.this.handler.sendEmptyMessageDelayed(1002, 12000L);
                        c2.LocationClientStateManager.this.reSendRequest();
                    }
                    return false;
                }
            };
            handler = new Handler((Looper)handlerThread2, callback2);
            this.handler = handler2;
        }
    }

    public synchronized void resetCache() {
        if (this.reConnectCount.get() == 0 && this.lastDisConnectTime.get() == 0L) {
            HMSLog.i((String)TAG, (String)"not need resetCache");
            return;
        }
        LocationClientStateManager locationClientStateManager = this;
        HMSLog.i((String)TAG, (String)"resetCache");
        locationClientStateManager.lastDisConnectTime.set(0L);
        locationClientStateManager.reConnectCount.set(0);
    }

    public synchronized int getResendState() {
        return this.resendState.get();
    }

    public synchronized void reStartHmsLocation() {
        LocationClientStateManager locationClientStateManager = this;
        HMSLog.i((String)TAG, (String)("reStartHmsLocation restartState\uff1a" + LocationClientStateManager.getInstance().getResendState()));
        LocationClientStateManager.getInstance().setResendState(1);
        locationClientStateManager.initHandler();
        locationClientStateManager.handler.sendEmptyMessageDelayed(1001, 300L);
    }

    public synchronized void checkCanResend() {
        boolean bl = LocationClientStateManager.getInstance().checkCanResendRequest();
        if (bl) {
            this.reStartHmsLocation();
        }
        HMSLog.i((String)TAG, (String)("checkCanResend:" + bl + ",reStartHmsLocation restartState\uff1a" + LocationClientStateManager.getInstance().getResendState()));
    }

    private static class d {
        private static final LocationClientStateManager a = new LocationClientStateManager();
    }
}

