/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.location.common;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.common.ApiException;
import com.huawei.hms.core.aidl.IMessageEntity;
import com.huawei.hms.location.LocationCallback;
import com.huawei.hms.location.LocationRequest;
import com.huawei.hms.locationSdk.e1;
import com.huawei.hms.locationSdk.h0;
import com.huawei.hms.locationSdk.h1;
import com.huawei.hms.locationSdk.i1;
import com.huawei.hms.locationSdk.j0;
import com.huawei.hms.locationSdk.j1;
import com.huawei.hms.locationSdk.k0;
import com.huawei.hms.locationSdk.k1;
import com.huawei.hms.locationSdk.n0;
import com.huawei.hms.locationSdk.v1;
import com.huawei.hms.support.api.client.Status;
import com.huawei.hms.support.api.entity.location.binder.InnerBinder;
import com.huawei.hms.support.api.entity.location.updates.RemoveLocationUpdatesRequest;
import com.huawei.hms.support.api.entity.location.updates.RequestLocationUpdatesRequest;
import com.huawei.hms.support.api.location.common.HMSLocationLog;
import com.huawei.hms.support.api.location.common.PermissionUtil;
import com.huawei.hms.support.api.location.common.exception.LocationStatusCode;
import com.huawei.hms.support.log.HMSLog;
import com.huawei.hms.utils.JsonUtil;
import com.huawei.location.lite.common.android.context.ContextUtil;
import com.huawei.location.lite.common.log.LogLocation;
import com.huawei.location.lite.common.report.ReportBuilder;
import com.huawei.location.lite.common.report.Tracker;
import com.huawei.location.lite.common.util.APKUtil;
import com.huawei.location.lite.common.util.LocationUtil;
import com.huawei.location.lite.common.util.NetworkUtil;
import com.huawei.location.lite.common.util.ReflectionUtils;
import com.huawei.location.lite.common.util.TelephonyUtil;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationRequestHelper {
    private static final String TAG = "LocationRequestHelper";
    private static final String VDR_GNSS_OPTION = "vdrEnable";
    private static final String VDR_ENABLE = "1";
    private static final String LOCATION_REQUEST_API_NAME = "Location_requestLocationUpdates_SDK";
    public static final String CP_TRANS_ID = "cpTransId";

    public static n0 createRequestApiCall(String string, LocationRequest object, LocationCallback locationCallback, Looper looper, PendingIntent pendingIntent, RequestLocationUpdatesRequest requestLocationUpdatesRequest) throws ApiException {
        k0 k02;
        String string2 = string;
        LocationRequestHelper.checkMethodSupport(string);
        LocationRequestHelper.checkRequestParam(string, object, locationCallback, looper, pendingIntent);
        LocationRequestHelper.checkLocationPermission();
        LocationRequestHelper.checkPriority(string, object);
        LocationRequestHelper.buildRequestEntity(string, object, locationCallback, requestLocationUpdatesRequest);
        k0 k03 = k02;
        LocationRequest locationRequest = object;
        object = requestLocationUpdatesRequest.getTid();
        k02 = new k0(locationRequest, pendingIntent, locationCallback, looper, (String)object, string);
        string = JsonUtil.createJsonString((IMessageEntity)requestLocationUpdatesRequest);
        return LocationRequestHelper.buildTaskApiCall(string2, locationCallback, looper, pendingIntent, requestLocationUpdatesRequest, k03, string);
    }

    private static void checkPriority(String string, LocationRequest locationRequest) throws ApiException {
        Status status;
        block9: {
            String string2 = string;
            string2.hashCode();
            int n2 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1366690360: {
                    if (!string.equals("ExCallback")) break;
                    n2 = 2;
                    break;
                }
                case -1598699650: {
                    if (!string.equals("NORMAL Callback")) break;
                    n2 = 1;
                    break;
                }
                case -2099895620: {
                    if (!string.equals("Intent")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 2: {
                    if (locationRequest.getPriority() != 200) break;
                    locationRequest.setNeedAddress(false);
                    break;
                }
                case 0: 
                case 1: {
                    if (locationRequest.getPriority() == 200 || locationRequest.getPriority() == 300 || locationRequest.getPriority() == 400) break block9;
                }
            }
            return;
        }
        string = status;
        status = new Status(10807, LocationStatusCode.getStatusCodeString((int)10807));
        throw new ApiException((Status)string);
    }

    private static void buildRequestEntity(String string, LocationRequest locationRequest, LocationCallback locationCallback, RequestLocationUpdatesRequest requestLocationUpdatesRequest) {
        requestLocationUpdatesRequest.setLocationRequest(locationRequest);
        if (!TextUtils.equals((CharSequence)string, (CharSequence)"Intent")) {
            requestLocationUpdatesRequest.setUuid(locationCallback.getUuid());
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"ExCallback")) {
            locationRequest.putExtras("productId", LocationRequestHelper.getProductId());
        }
    }

    private static String getProductId() {
        try {
            return AGConnectServicesConfig.fromContext((Context)ContextUtil.getContext()).getString("client/product_id");
        }
        catch (Exception exception) {
            HMSLog.e((String)TAG, (String)"get agc productId by exception");
            return "";
        }
    }

    @Nullable
    private static n0 buildTaskApiCall(String object, LocationCallback object2, Looper looper, PendingIntent object3, RequestLocationUpdatesRequest requestLocationUpdatesRequest, k0 k02, String string) throws ApiException {
        String string2 = requestLocationUpdatesRequest.getTid();
        int n2 = -1;
        int n3 = object.hashCode();
        if (n3 != -2099895620) {
            if (n3 != -1598699650) {
                if (n3 == 1366690360 && object.equals("ExCallback")) {
                    n2 = 0;
                }
            } else if (object.equals("NORMAL Callback")) {
                n2 = 2;
            }
        } else if (object.equals("Intent")) {
            n2 = 1;
        }
        if (n2 != 0) {
            if (n2 != 1) {
                j1 j12;
                object = j12;
                new j1("location.requestLocationUpdates", string, string2, k02, looper, "").setParcelable((Parcelable)InnerBinder.getInnerBinder());
                object2 = "requestLocationUpdates with callback uuid=" + ((LocationCallback)object2).getUuid() + ", tid=" + requestLocationUpdatesRequest.getTid() + ", Version Code = " + 61200300;
                HMSLocationLog.i(TAG, string2, (String)object2);
            } else {
                k1 k12;
                object = k12;
                ((k1)((Object)object))("location.requestLocationUpdates", string, string2, k02, "");
                k12.setParcelable((Parcelable)object3);
                object2 = "requestLocationUpdates with intent tid = " + requestLocationUpdatesRequest.getTid() + " Version Code = " + 61200300;
                HMSLocationLog.i(TAG, string2, (String)object2);
            }
        } else {
            if (LocationRequestHelper.isVdrEnable(requestLocationUpdatesRequest)) {
                i1 i12;
                object = i12;
                object3 = requestLocationUpdatesRequest.getPackageName();
                i12 = new i1("location.requestLocationUpdatesEx", string, string2, k02, looper, "", (String)object3);
            } else {
                h1 h12;
                object = h12;
                h12 = new h1("location.requestLocationUpdatesEx", string, string2, k02, looper, "");
            }
            object.setParcelable((Parcelable)InnerBinder.getInnerBinder());
            object2 = "requestLocationUpdates with callback uuid=" + ((LocationCallback)object2).getUuid() + ", tid=" + requestLocationUpdatesRequest.getTid() + ", Version Code = " + 61200300;
            HMSLocationLog.i(TAG, string2, (String)object2);
        }
        LocationRequestHelper.logCurrentStatus(requestLocationUpdatesRequest.getLocationRequest(), string2, ContextUtil.getContext());
        return object;
    }

    private static void logCurrentStatus(LocationRequest object, String string, Context object2) {
        StringBuilder stringBuilder;
        if (object2 != null && object != null) {
            object = "priority: " + object.getPriority() + ", locationMode: " + LocationUtil.isLocationEnabled((Context)object2) + ", netWork available: " + NetworkUtil.isNetworkAvailable((Context)object2) + ", model is: " + Build.MODEL + ",WLANScan:" + TelephonyUtil.checkWLANScan((Context)ContextUtil.getContext());
            HMSLocationLog.i(TAG, string, (String)object);
            return;
        }
        Context context = object2;
        object2 = TAG;
        CharSequence charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        String string2 = context == null ? "context is null, " : "context is not null, ";
        LocationRequest locationRequest = object;
        object = charSequence.append(string2);
        charSequence = locationRequest == null ? "request is null, " : "request is not null, ";
        HMSLocationLog.e((String)object2, string, ((StringBuilder)object).append((String)charSequence).toString());
    }

    private static void checkLocationPermission() throws ApiException {
        Status status;
        if (PermissionUtil.isLocationPermissionAvailable(ContextUtil.getContext())) {
            return;
        }
        Status status2 = status;
        status = new Status(10803, LocationStatusCode.getStatusCodeString((int)10803));
        throw new ApiException(status2);
    }

    public static void assertNoNull(Object object) throws ApiException {
        Status status;
        if (object != null) {
            return;
        }
        object = status;
        status = new Status(10801, LocationStatusCode.getStatusCodeString((int)10801));
        throw new ApiException((Status)object);
    }

    private static void checkRequestParam(String string, LocationRequest locationRequest, LocationCallback locationCallback, Looper looper, PendingIntent pendingIntent) throws ApiException {
        Status status;
        LocationRequestHelper.assertNoNull(locationRequest);
        int n2 = -1;
        int n3 = string.hashCode();
        if (n3 != -2099895620) {
            if (n3 != -1598699650) {
                if (n3 == 1366690360 && string.equals("ExCallback")) {
                    n2 = 2;
                }
            } else if (string.equals("NORMAL Callback")) {
                n2 = 1;
            }
        } else if (string.equals("Intent")) {
            n2 = 0;
        }
        if (n2 != 0) {
            LocationRequestHelper.assertNoNull(locationCallback);
            LocationRequestHelper.assertNoNull(looper);
        } else {
            LocationRequestHelper.assertNoNull(pendingIntent);
        }
        if (locationRequest.getNumUpdates() > 0) {
            if (locationRequest.getCoordinateType() != 0 && locationRequest.getCoordinateType() != 1) {
                Status status2;
                string = status2;
                status2 = new Status(10802, LocationStatusCode.getStatusCodeString((int)10802));
                throw new ApiException((Status)string);
            }
            return;
        }
        string = status;
        status = new Status(10802, LocationStatusCode.getStatusCodeString((int)10802));
        throw new ApiException((Status)string);
    }

    private static boolean isVdrEnable(RequestLocationUpdatesRequest requestLocationUpdatesRequest) {
        if (requestLocationUpdatesRequest.getLocationRequest().getPriority() != 200) {
            LogLocation.i((String)TAG, (String)("do not support vdr, priority is: " + requestLocationUpdatesRequest.getLocationRequest().getPriority()));
            return false;
        }
        if (!ReflectionUtils.isSupportClass((String)"com.huawei.location.vdr.VdrManager")) {
            LogLocation.i((String)TAG, (String)"no vdr module, do not support vdr");
            return false;
        }
        if (Build.VERSION.SDK_INT < 24) {
            LogLocation.i((String)TAG, (String)"SDK_INT less than N, do not support vdr");
            return false;
        }
        return TextUtils.equals((CharSequence)LocationRequestHelper.getOption(requestLocationUpdatesRequest), (CharSequence)VDR_ENABLE);
    }

    private static String getOption(RequestLocationUpdatesRequest object) {
        RequestLocationUpdatesRequest requestLocationUpdatesRequest = object;
        object = "";
        Map map = requestLocationUpdatesRequest.getLocationRequest().getExtras();
        if (map != null) {
            object = (String)map.get(VDR_GNSS_OPTION);
        }
        LogLocation.i((String)TAG, (String)("vdrEnable is: " + (String)object));
        return object;
    }

    private static void checkMethodSupport(String string) throws ApiException {
        if (TextUtils.equals((CharSequence)string, (CharSequence)"Intent") && !v1.a(ContextUtil.getContext())) {
            Status status;
            string = status;
            status = new Status(10806, LocationStatusCode.getStatusCodeString((int)10806));
            throw new ApiException((Status)string);
        }
    }

    public static n0 createRemoveTaskApiCall(LocationCallback object, PendingIntent pendingIntent, String string, String object2, RemoveLocationUpdatesRequest object3) throws ApiException {
        e1 e12;
        object2 = LocationRequestHelper.createRemoveLocationUpdatesCache((LocationCallback)object, pendingIntent, string, (String)object2);
        String string2 = ((h0)object2).a();
        object3.setTid(string2);
        if (TextUtils.equals((CharSequence)string, (CharSequence)"NORMAL Callback")) {
            object3.setUuid(((LocationCallback)object).getUuid());
        }
        object = JsonUtil.createJsonString((IMessageEntity)object3);
        object3 = e12;
        e12 = new e1("location.removeLocationUpdates", (String)object, string2, (k0)object2, "");
        if (TextUtils.equals((CharSequence)string, (CharSequence)"Intent")) {
            object3.setParcelable((Parcelable)pendingIntent);
        }
        object = string + " removeLocationUpdates tid =" + string2 + " Version Code = " + 61200300;
        HMSLocationLog.i(TAG, string2, (String)object);
        return object3;
    }

    @NonNull
    private static k0 createRemoveLocationUpdatesCache(LocationCallback object, PendingIntent pendingIntent, String string, String string2) throws ApiException {
        k0 k02;
        LocationRequestHelper.checkRemoveRequestParam((LocationCallback)object, pendingIntent, string);
        k0 k03 = k02;
        k02 = new k0(null, pendingIntent, (LocationCallback)object, null, string2, string);
        object = j0.b().b(k03);
        if (object == null) {
            Status status;
            int n2 = -1;
            int n3 = string.hashCode();
            if (n3 != -2099895620) {
                if (n3 == -1598699650 && string.equals("NORMAL Callback")) {
                    n2 = 1;
                }
            } else if (string.equals("Intent")) {
                n2 = 0;
            }
            if (n2 != 0) {
                Status status2;
                HMSLocationLog.e(TAG, string2, "remove location updates with callback cannot find callback");
                Status status3 = status2;
                status2 = new Status(10804, LocationStatusCode.getStatusCodeString((int)10804));
                throw new ApiException(status3);
            }
            HMSLocationLog.e(TAG, string2, "remove location updates with intent cannot find intent");
            Status status4 = status;
            status = new Status(10805, LocationStatusCode.getStatusCodeString((int)10805));
            throw new ApiException(status4);
        }
        return object;
    }

    private static void checkRemoveRequestParam(LocationCallback locationCallback, PendingIntent pendingIntent, String string) throws ApiException {
        int n2 = -1;
        int n3 = string.hashCode();
        if (n3 != -2099895620) {
            if (n3 == -1598699650 && string.equals("NORMAL Callback")) {
                n2 = 1;
            }
        } else if (string.equals("Intent")) {
            n2 = 0;
        }
        if (n2 != 0) {
            LocationRequestHelper.assertNoNull(locationCallback);
        } else {
            LocationRequestHelper.assertNoNull(pendingIntent);
        }
    }

    public static String getCpTid(LocationRequest object) {
        if (object == null) {
            return "";
        }
        if ((object = object.getExtras()) != null && !object.isEmpty()) {
            return (String)object.get(CP_TRANS_ID);
        }
        return "";
    }

    public static void reportRequest(String string, int n2, String string2, String string3) {
        ReportBuilder reportBuilder;
        ReportBuilder reportBuilder2;
        ReportBuilder reportBuilder3 = reportBuilder2 = reportBuilder;
        ReportBuilder reportBuilder4 = reportBuilder2;
        reportBuilder4();
        reportBuilder4.setApiName(LOCATION_REQUEST_API_NAME);
        reportBuilder4.setWLANScan();
        reportBuilder4.setLocationEnable(LocationUtil.isLocationEnabled((Context)ContextUtil.getContext()));
        reportBuilder3.setTransactionID(string);
        reportBuilder3.setPackage(ContextUtil.getContext().getPackageName());
        reportBuilder3.setCpAppVersion(APKUtil.getPackageVersionName((String)ContextUtil.getContext().getPackageName()));
        reportBuilder3.setErrorCode(n2 + "");
        reportBuilder.setErrorMessage(string2);
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject;
        jSONObject.put(CP_TRANS_ID, (Object)string3);
        try {
            reportBuilder.setExt(jSONObject2.toString());
        }
        catch (JSONException jSONException) {
            HMSLocationLog.i(TAG, string, "reportRequest put ext failed");
        }
        Tracker.getInstance().onMaintEvent(reportBuilder2);
        Tracker.getInstance().onReport();
    }
}

