/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.hms.support.api.location.common;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.core.content.PermissionChecker;
import com.huawei.hms.support.log.HMSLog;
import java.util.Iterator;

public class PermissionUtil {
    private static final String TAG = "PermissionUtil";

    public static boolean isLocationPermissionAvailable(Context context) {
        if (!PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION") && !PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            HMSLog.i((String)TAG, (String)"checkSelfPermission is false");
            return false;
        }
        if (Build.VERSION.SDK_INT <= 28) {
            return true;
        }
        if (PermissionUtil.isAppIsInBackground(context) && !PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_BACKGROUND_LOCATION")) {
            HMSLog.i((String)TAG, (String)"App is in background , but BackgroundPermission is false");
            return false;
        }
        return true;
    }

    public static boolean isAppIsInBackground(Context context) {
        if (context == null) {
            HMSLog.e((String)TAG, (String)"context is null");
            return false;
        }
        boolean bl = true;
        Iterator iterator = context.getSystemService("activity");
        if (!(iterator instanceof ActivityManager)) {
            HMSLog.e((String)TAG, (String)"managerResult is not a instance of ActivityManager");
            return false;
        }
        iterator = (ActivityManager)iterator;
        if (Build.VERSION.SDK_INT >= 21) {
            if ((iterator = iterator.getRunningAppProcesses()) == null) {
                HMSLog.e((String)TAG, (String)"runningProcesses is null");
                return false;
            }
            iterator = iterator.iterator();
            block0: while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                if (!PermissionUtil.isImportanceForeground(stringArray.importance)) continue;
                stringArray = stringArray.pkgList;
                int n2 = stringArray.pkgList.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!stringArray[i2].equals(context.getPackageName())) continue;
                    bl = false;
                    continue block0;
                }
            }
            return bl;
        }
        HMSLog.e((String)TAG, (String)"android version is lower than 21");
        return false;
    }

    private static boolean isImportanceForeground(int n2) {
        if (Build.VERSION.SDK_INT > 23) {
            return n2 <= 125;
        }
        return n2 <= 100;
    }

    public static boolean isGeofencePermissionAvailable(Context context) {
        if (PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_FINE_LOCATION")) {
            if (Build.VERSION.SDK_INT <= 28) {
                return true;
            }
            return PermissionUtil.checkSelfPermission(context, "android.permission.ACCESS_BACKGROUND_LOCATION");
        }
        return false;
    }

    public static boolean canAccessMockLocation(String string, Context object) {
        block9: {
            block10: {
                if (Build.VERSION.SDK_INT < 23) break block9;
                object = object.getSystemService("appops");
                if (!(object instanceof AppOpsManager)) break block10;
                return ((AppOpsManager)object).noteOp("android:mock_location", Process.myUid(), string) == 0;
            }
            HMSLog.i((String)TAG, (String)"canCallerAccessMockLocation ,no AppOpsManager ");
            return false;
        }
        boolean bl = Settings.Secure.getInt((ContentResolver)object.getContentResolver(), (String)"mock_location", (int)0) != 0;
        try {
            HMSLog.i((String)TAG, (String)("canCallerAccessMockLocation ,Build.VERSION.SDK_INT <23 ,mock is " + bl));
            return bl;
        }
        catch (Exception exception) {
            HMSLog.i((String)TAG, (String)"canCallerAccessMockLocation ,Exception ");
            return false;
        }
        catch (SecurityException securityException) {
            HMSLog.i((String)TAG, (String)"canCallerAccessMockLocation ,SecurityException ");
            return false;
        }
    }

    public static boolean isPermissionAvailable(Context context, String string) {
        return PermissionUtil.checkSelfPermission(context, string);
    }

    private static boolean checkSelfPermission(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            HMSLog.i((String)TAG, (String)"permission is null");
            return false;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return context.checkPermission(string, Process.myPid(), Process.myUid()) == 0;
        }
        return PermissionChecker.checkSelfPermission((Context)context, (String)string) == 0;
    }
}

