/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.secure.android.common.intent;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.ActivityNotFoundException;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.huawei.secure.android.common.activity.a;
import com.huawei.secure.android.common.intent.SafeIntent;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;

public class IntentUtils {
    private static final String a = "IntentUtils";
    private static final int b = 750000;

    public static boolean safeHasExtra(Intent intent, String string) {
        try {
            return intent.hasExtra(string);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static void safeRemoveExtra(Intent intent, String string) {
        try {
            intent.removeExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "removeExtra failed on intent " + throwable.getMessage(), true);
        }
    }

    public static boolean safeGetBoolean(Bundle bundle, String string) {
        return IntentUtils.safeGetBoolean(bundle, string, false);
    }

    public static boolean safeGetBoolean(Bundle bundle, String string, boolean bl) {
        try {
            return bundle.getBoolean(string, bl);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getBoolean failed with throwable: " + throwable.getMessage());
            return bl;
        }
    }

    public static boolean safeGetBooleanExtra(Intent intent, String string, boolean bl) {
        try {
            return intent.getBooleanExtra(string, bl);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getBooleanExtra failed on intent " + throwable.getMessage(), true);
            return bl;
        }
    }

    public static int safeGetIntExtra(Intent intent, String string, int n) {
        try {
            return intent.getIntExtra(string, n);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getIntExtra failed on intent " + throwable.getMessage(), true);
            return n;
        }
    }

    public static int safeGetInt(Bundle bundle, String string, int n) {
        try {
            return bundle.getInt(string, n);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getInt failed on bundle " + throwable.getMessage(), true);
            return n;
        }
    }

    public static int[] safeGetIntArrayExtra(Intent intent, String string) {
        try {
            return intent.getIntArrayExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getIntArrayExtra failed on intent " + throwable.getMessage(), true);
            return new int[0];
        }
    }

    public static int[] safeGetIntArray(Bundle bundle, String string) {
        try {
            return bundle.getIntArray(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getIntArray failed on bundle " + throwable.getMessage(), true);
            return new int[0];
        }
    }

    public static long safeGetLongExtra(Intent intent, String string, long l) {
        try {
            return intent.getLongExtra(string, l);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getLongExtra failed on intent " + throwable.getMessage(), true);
            return l;
        }
    }

    public static String safeGetStringExtra(Intent intent, String string) {
        try {
            return intent.getStringExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getStringExtra failed on intent " + throwable.getMessage(), true);
            return "";
        }
    }

    public static String safeGetString(Bundle bundle, String string) {
        try {
            return bundle.getString(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getString failed on bundle " + throwable.getMessage(), true);
            return "";
        }
    }

    public static Bundle safeGetBundleExtra(Intent intent, String string) {
        try {
            return intent.getBundleExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getBundleExtra failed on intent " + throwable.getMessage(), true);
            return new Bundle();
        }
    }

    public static Bundle safeGetBundle(Bundle bundle, String string) {
        try {
            return bundle.getBundle(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getBundle failed on bundle " + throwable.getMessage(), true);
            return new Bundle();
        }
    }

    @Deprecated
    public static <T extends Parcelable> T safeGetParcelable(Bundle bundle, String string) {
        try {
            return (T)bundle.getParcelable(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getParcelable failed on bundle " + throwable.getMessage(), true);
            return null;
        }
    }

    @Deprecated
    public static <T extends Parcelable> T safeGetParcelableExtra(Intent intent, String string) {
        try {
            return (T)intent.getParcelableExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getParcelableExtra failed on intent " + throwable.getMessage(), true);
            return null;
        }
    }

    public static <T extends Parcelable> ArrayList<T> getParcelableArrayListExtra(Intent intent, String string) {
        try {
            return intent.getParcelableArrayListExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getParcelableArrayListExtra failed on intent " + throwable.getMessage(), true);
            return null;
        }
    }

    public static Parcelable[] safeGetParcelableArrayExtra(Intent intent, String string) {
        try {
            return intent.getParcelableArrayExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getParcelableArrayExtra failed on intent " + throwable.getMessage(), true);
            return new Parcelable[0];
        }
    }

    public static ArrayList<String> safeGetStringArrayListExtra(Intent intent, String string) {
        try {
            return intent.getStringArrayListExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getStringArrayListExtra failed on intent " + throwable.getMessage(), true);
            return new ArrayList<String>();
        }
    }

    public static byte[] safeGetByteArrayExtra(Intent intent, String string) {
        try {
            return intent.getByteArrayExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getByteArrayExtra failed on intent " + throwable.getMessage(), true);
            return new byte[0];
        }
    }

    @Deprecated
    public static <T extends Serializable> T safeGetSerializableExtra(Intent intent, String string) {
        try {
            return (T)intent.getSerializableExtra(string);
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getSerializableExtra failed on intent " + throwable.getMessage(), true);
            return null;
        }
        catch (ClassCastException classCastException) {
            com.huawei.secure.android.common.activity.a.a(a, "Invalide class for Serializable: " + classCastException.getMessage(), true);
            return null;
        }
    }

    public static boolean safeStartActivity(Context context, Intent intent) {
        return IntentUtils.safeStartActivity(context, intent, null);
    }

    @SuppressLint(value={"NewApi"})
    public static boolean safeStartActivity(Context context, Intent intent, Bundle bundle) {
        try {
            context.startActivity(intent, bundle);
            return true;
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: throwable");
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: Exception");
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivity: ActivityNotFoundException ", activityNotFoundException);
        }
        return false;
    }

    public static int getParceledIntentSize(Intent intent) {
        Intent intent2 = intent;
        intent = Parcel.obtain();
        intent2.writeToParcel((Parcel)intent, 0);
        int n = intent.dataSize();
        intent.recycle();
        return n;
    }

    public static boolean isIntentTooLarge(Intent intent) {
        return IntentUtils.getParceledIntentSize(intent) > 750000;
    }

    public static boolean safeStartActivityForResultStatic(Activity activity, Intent intent, int n) {
        try {
            activity.startActivityForResult(intent, n);
            return true;
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: throwable ", throwable);
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: Exception ", exception);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: ActivityNotFoundException ", activityNotFoundException);
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean safeStartActivityForResultStatic(Activity activity, Intent intent, int n, Bundle bundle) {
        try {
            activity.startActivityForResult(intent, n, bundle);
            return true;
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: throwable");
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: Exception");
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: ActivityNotFoundException ", activityNotFoundException);
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static Uri getReferrer(Activity activity) {
        try {
            return activity.getReferrer();
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "getReferrer: " + throwable.getMessage(), true);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasIntentBomb(Intent intent) {
        boolean bl = false;
        if (intent == null) {
            com.huawei.secure.android.common.activity.a.a(a, "intent is null");
            bl = true;
        } else if (intent instanceof SafeIntent) {
            com.huawei.secure.android.common.activity.a.b(a, "safe intent");
            bl = ((SafeIntent)intent).hasIntentBomb();
        } else {
            try {
                intent.getStringExtra("ANYTHING");
            }
            catch (Throwable throwable) {
                bl = true;
            }
        }
        if (bl) {
            com.huawei.secure.android.common.activity.a.a(a, "hasIntentBomb");
        }
        return bl;
    }

    public static <T extends Parcelable> T safeGetParcelable(Bundle bundle, String string, Class<T> clazz) {
        block4: {
            Class<T> clazz2 = clazz;
            bundle = bundle.getParcelable(string);
            if (!clazz2.isInstance(bundle)) break block4;
            try {
                return (T)((Parcelable)clazz.cast(bundle));
            }
            catch (Throwable throwable) {
                com.huawei.secure.android.common.activity.a.a(a, "getParcelable exception: " + throwable.getMessage(), true);
            }
        }
        return null;
    }

    public static <T extends Serializable> T safeGetSerializable(Bundle object, String string, Class<T> clazz) {
        block4: {
            Class<T> clazz2 = clazz;
            object = object.getSerializable(string);
            if (!clazz2.isInstance(object)) break block4;
            try {
                return (T)((Serializable)clazz.cast(object));
            }
            catch (Throwable throwable) {
                com.huawei.secure.android.common.activity.a.a(a, "getSerializable exception: " + throwable.getMessage(), true);
            }
        }
        return null;
    }

    public static <T extends Parcelable> T safeGetParcelableExtra(Intent intent, String string, Class<T> clazz) {
        block4: {
            Class<T> clazz2 = clazz;
            intent = intent.getParcelableExtra(string);
            if (!clazz2.isInstance(intent)) break block4;
            try {
                return (T)((Parcelable)clazz.cast(intent));
            }
            catch (Throwable throwable) {
                com.huawei.secure.android.common.activity.a.a(a, "getParcelable exception: " + throwable.getMessage(), true);
            }
        }
        return null;
    }

    public static <T extends Serializable> T safeGetSerializableExtra(Intent object, String string, Class<T> clazz) {
        block4: {
            Class<T> clazz2 = clazz;
            object = object.getSerializableExtra(string);
            if (!clazz2.isInstance(object)) break block4;
            try {
                return (T)((Serializable)clazz.cast(object));
            }
            catch (Throwable throwable) {
                com.huawei.secure.android.common.activity.a.a(a, "getSerializable exception: " + throwable.getMessage(), true);
            }
        }
        return null;
    }

    public static void filterIntentRWPermission(Intent intent) {
        if (intent == null) {
            return;
        }
        int n = intent.getFlags();
        if (Build.VERSION.SDK_INT >= 19) {
            n &= 0xFFFFFFBF;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            n &= 0xFFFFFF7F;
        }
        intent.setFlags(n & 0xFFFFFFFE & 0xFFFFFFFD);
    }

    public static void filterIntentComAndSel(Intent intent) {
        if (intent == null) {
            return;
        }
        intent.addCategory("android.intent.category.BROWSABLE").setComponent(null);
        if (Build.VERSION.SDK_INT >= 15) {
            intent.setSelector(null);
        }
    }

    public static void filterIntentClipData(Intent intent) {
        if (intent == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 16 && intent.getClipData() == null) {
            intent.setClipData(ClipData.newPlainText((CharSequence)"avoid intent migrateExtraStreamToClipData add flags", (CharSequence)"anything"));
        }
    }

    public static void filterIntent(Intent intent) {
        Intent intent2 = intent;
        IntentUtils.filterIntentComAndSel(intent2);
        IntentUtils.filterIntentClipData(intent2);
        IntentUtils.filterIntentRWPermission(intent2);
    }

    public static Intent safeParseUri(String string, int n) throws URISyntaxException {
        if (string == null) {
            return null;
        }
        Intent intent = Intent.parseUri((String)string, (int)n);
        IntentUtils.filterIntent(intent);
        return intent;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String getCallerPackage(Activity var0) {
        block18: {
            com.huawei.secure.android.common.activity.a.b("IntentUtils", "getCallerPackage");
            if (var0 == null) {
                com.huawei.secure.android.common.activity.a.a("IntentUtils", "getCallerPackage, activity is null");
                return "";
            }
            if (Build.VERSION.SDK_INT < 26) break block18;
            v0 = ActivityManager.class;
            v1 = v0.getMethod("getService", new Class[0]);
            v2 = v1.invoke(null, new Object[0]);
lbl13:
            // 2 sources

            while (true) {
                var1_4 = v2;
                ** GOTO lbl27
                break;
            }
        }
        try {
            v3 = Class.forName("android.app.ActivityManagerNative");
        }
        catch (Exception var0_3) {
            com.huawei.secure.android.common.activity.a.a("IntentUtils", "getCallerPackage exception: " + var0_3.getMessage(), true);
            return "";
        }
        v4 = v3.getMethod("getDefault", new Class[0]);
        v2 = v4.invoke(null, new Object[0]);
        ** continue;
lbl27:
        // 1 sources

        v5 = var0;
        v6 = var1_4;
        v7 = Activity.class;
        var0 = (IBinder)v7.getMethod("getActivityToken", new Class[0]).invoke((Object)var0, new Object[0]);
        v8 = v6.getClass();
        v9 = new Class[1];
        v9[0] = IBinder.class;
        var0_1 = (Integer)v8.getMethod("getLaunchedFromUid", v9).invoke(var1_4, new Object[]{var0});
        var0_2 /* !! */  = v5.getPackageManager().getPackagesForUid(var0_1);
        if (var0_2 /* !! */  == null) ** GOTO lbl49
        if (var0_2 /* !! */ .length < 1) ** GOTO lbl49
        var0_2 /* !! */  = var0_2 /* !! */ [0];
        com.huawei.secure.android.common.activity.a.b("IntentUtils", "getCallerPackage, package is: " + (String)var0_2 /* !! */ );
        return var0_2 /* !! */ ;
lbl49:
        // 2 sources

        com.huawei.secure.android.common.activity.a.a("IntentUtils", "getCallerPackage, packages is null or empty");
        return "";
    }

    @Deprecated
    public boolean safeStartActivityForResult(Activity activity, Intent intent, int n) {
        try {
            activity.startActivityForResult(intent, n);
            return true;
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: throwable ", throwable);
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: Exception ", exception);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: ActivityNotFoundException ", activityNotFoundException);
        }
        return false;
    }

    @Deprecated
    @SuppressLint(value={"NewApi"})
    public boolean safeStartActivityForResult(Activity activity, Intent intent, int n, Bundle bundle) {
        try {
            activity.startActivityForResult(intent, n, bundle);
            return true;
        }
        catch (Throwable throwable) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: throwable");
        }
        catch (Exception exception) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: Exception");
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            com.huawei.secure.android.common.activity.a.a(a, "safeStartActivityForResult: ActivityNotFoundException ", activityNotFoundException);
        }
        return false;
    }
}

