/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.async;

import com.huawei.wisesecurity.kfs.async.LruMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class LruCache<T> {
    private final AtomicInteger counter = new AtomicInteger();
    private final Map<Integer, T> cachedValues;

    public LruCache(int n2) {
        this.cachedValues = Collections.synchronizedMap(new LruMap(n2));
    }

    public Map.Entry<Integer, T> newCacheValue(T t2) {
        LruCache lruCache = this;
        int n2 = lruCache.counter.getAndIncrement();
        lruCache.cachedValues.put(n2, t2);
        return new AbstractMap.SimpleEntry<Integer, T>(n2, t2);
    }

    public T putCachedValue(int n2, T t2) {
        return this.cachedValues.put(n2, t2);
    }

    public T getCachedValue(int n2) {
        return this.cachedValues.get(n2);
    }

    public T removeCachedValue(int n2) {
        return this.cachedValues.remove(n2);
    }

    public boolean hasCachedValue(int n2) {
        return this.cachedValues.containsKey(n2);
    }
}

