/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto;

import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;

public abstract class AsymmetricBuilder<T> {
    public PrivateKey privateKey;
    public PublicKey publicKey;
    public AlgorithmParameterSpec parameterSpec;
    public final KeyStoreProvider keyStoreProvider;

    public AsymmetricBuilder(KeyStoreProvider keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public AsymmetricBuilder<T> withKey(Key key) {
        if (key instanceof PrivateKey) {
            this.privateKey = (PrivateKey)key;
        } else if (key instanceof PublicKey) {
            this.publicKey = (PublicKey)key;
        }
        return this;
    }

    public AsymmetricBuilder<T> withPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    public AsymmetricBuilder<T> withPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AsymmetricBuilder<T> withKeyStoreAlias(String string) throws KfsException {
        void var0_6;
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreProvider.getName());
        keyStore.load(null);
        Key key = keyStore.getKey(string, null);
        if (!(key instanceof PrivateKey)) throw new KfsException("bad private key type");
        try {
            this.privateKey = (PrivateKey)key;
            this.publicKey = keyStore.getCertificate(string).getPublicKey();
            return this;
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }
        catch (IOException iOException) {
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }
        catch (CertificateException certificateException) {
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
    }

    public AsymmetricBuilder<T> withParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.parameterSpec = algorithmParameterSpec;
        return this;
    }

    public abstract T build() throws CryptoException;
}

