/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.cipher;

import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.crypto.cipher.aes.AESCipher;
import com.huawei.wisesecurity.kfs.crypto.cipher.rsa.RSACipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

public class CipherFactory {
    private CipherFactory() {
    }

    public static KfsCipher getCipher(CipherAlg cipherAlg, Key key, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws CryptoException {
        return CipherFactory.getCipher(KeyStoreProvider.ANDROID_KEYSTORE, cipherAlg, key, byArray, algorithmParameterSpec);
    }

    public static KfsCipher getCipher(KeyStoreProvider keyStoreProvider, CipherAlg cipherAlg, Key key, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws CryptoException {
        switch (1.$SwitchMap$com$huawei$wisesecurity$kfs$crypto$cipher$CipherAlg[cipherAlg.ordinal()]) {
            default: {
                throw new CryptoException(f.a("unsupported alg : ").append(cipherAlg.getTransformation()).toString());
            }
            case 4: {
                return (KfsCipher)new RSACipher.Builder(keyStoreProvider).withAlg(cipherAlg).withKey(key).withParameterSpec(algorithmParameterSpec).build();
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return new AESCipher.Builder(keyStoreProvider).withAlg(cipherAlg).withKey(key).withIv(byArray).build();
    }
}

