/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.cipher;

import com.huawei.wisesecurity.kfs.crypto.cipher.CipherText;
import com.huawei.wisesecurity.kfs.crypto.cipher.DecryptHandler;
import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.codec.Encoder;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class DefaultDecryptHandler
implements DecryptHandler {
    private final Key key;
    private final AlgorithmParameterSpec parameterSpec;
    private final CipherText cipherText;
    private final KeyStoreProvider provider;

    public DefaultDecryptHandler(Key key, CipherText cipherText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = KeyStoreProvider.ANDROID_KEYSTORE;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.cipherText = cipherText;
    }

    public DefaultDecryptHandler(KeyStoreProvider keyStoreProvider, Key key, CipherText cipherText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.cipherText = cipherText;
    }

    private DefaultDecryptHandler from(String string, Decoder decoder) throws CryptoException {
        DefaultDecryptHandler defaultDecryptHandler;
        try {
            DefaultDecryptHandler defaultDecryptHandler2 = this;
            defaultDecryptHandler = defaultDecryptHandler2;
            defaultDecryptHandler2.from(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode cipher text: ").append(codecException.getMessage()).toString());
        }
        return defaultDecryptHandler;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] doDecrypt() throws CryptoException {
        void var0_9;
        DefaultDecryptHandler defaultDecryptHandler = this;
        Object object = defaultDecryptHandler.cipherText.getAlgId().getTransformation();
        KeyStoreProvider keyStoreProvider = defaultDecryptHandler.provider;
        object = keyStoreProvider == KeyStoreProvider.ANDROID_KEYSTORE ? Cipher.getInstance((String)object) : Cipher.getInstance((String)object, keyStoreProvider.getProviderName());
        Object object2 = object;
        Object object3 = object;
        DefaultDecryptHandler defaultDecryptHandler2 = this;
        int n2 = 2;
        try {
            object = defaultDecryptHandler2.key;
            AlgorithmParameterSpec algorithmParameterSpec = defaultDecryptHandler2.parameterSpec;
            ((Cipher)object3).init(n2, (Key)object, algorithmParameterSpec);
            return ((Cipher)object2).doFinal(this.cipherText.getCipherBytes());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to decrypt: ").append(var0_9.getMessage()).toString());
    }

    private String to(Encoder encoder) throws CryptoException {
        try {
            return encoder.encode(this.to());
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to encode plain text: ").append(codecException.getMessage()).toString());
        }
    }

    @Override
    public DefaultDecryptHandler from(byte[] byArray) throws CryptoException {
        DefaultDecryptHandler defaultDecryptHandler = this;
        defaultDecryptHandler.cipherText.setCipherBytes(byArray);
        return defaultDecryptHandler;
    }

    @Override
    public DefaultDecryptHandler fromBase64(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64);
    }

    @Override
    public DefaultDecryptHandler fromBase64Url(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64URL);
    }

    @Override
    public DefaultDecryptHandler fromHex(String string) throws CryptoException {
        return this.from(string, Decoder.HEX);
    }

    @Override
    public byte[] to() throws CryptoException {
        return this.doDecrypt();
    }

    @Override
    public String toBase64() throws CryptoException {
        return this.to(Encoder.BASE64);
    }

    @Override
    public String toHex() throws CryptoException {
        return this.to(Encoder.HEX);
    }

    @Override
    public String toRawString() throws CryptoException {
        return this.to(Encoder.RAW);
    }
}

