/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.cipher;

import com.huawei.wisesecurity.kfs.crypto.cipher.CipherText;
import com.huawei.wisesecurity.kfs.crypto.cipher.EncryptHandler;
import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.codec.Encoder;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.util.ByteUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class DefaultEncryptHandler
implements EncryptHandler {
    private final Key key;
    private final AlgorithmParameterSpec parameterSpec;
    private final CipherText cipherText;
    private final KeyStoreProvider provider;

    public DefaultEncryptHandler(Key key, CipherText cipherText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = KeyStoreProvider.ANDROID_KEYSTORE;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.cipherText = cipherText;
    }

    public DefaultEncryptHandler(KeyStoreProvider keyStoreProvider, Key key, CipherText cipherText, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
        this.cipherText = cipherText;
    }

    private DefaultEncryptHandler from(String string, Decoder decoder) throws CryptoException {
        DefaultEncryptHandler defaultEncryptHandler;
        try {
            DefaultEncryptHandler defaultEncryptHandler2 = this;
            defaultEncryptHandler = defaultEncryptHandler2;
            defaultEncryptHandler2.from(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode plain text : ").append(codecException.getMessage()).toString());
        }
        return defaultEncryptHandler;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doEncrypt() throws CryptoException {
        void var0_9;
        DefaultEncryptHandler defaultEncryptHandler = this;
        Object object = defaultEncryptHandler.cipherText.getAlgId().getTransformation();
        KeyStoreProvider keyStoreProvider = defaultEncryptHandler.provider;
        object = keyStoreProvider == KeyStoreProvider.ANDROID_KEYSTORE ? Cipher.getInstance((String)object) : Cipher.getInstance((String)object, keyStoreProvider.getProviderName());
        DefaultEncryptHandler defaultEncryptHandler2 = this;
        int n2 = 1;
        Key key = defaultEncryptHandler2.key;
        AlgorithmParameterSpec algorithmParameterSpec = defaultEncryptHandler2.parameterSpec;
        ((Cipher)object).init(n2, key, algorithmParameterSpec);
        CipherText cipherText = this.cipherText;
        try {
            cipherText.setCipherBytes(((Cipher)object).doFinal(cipherText.getPlainBytes()));
            return;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (BadPaddingException badPaddingException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new CryptoException(f.a("Fail to encrypt: ").append(var0_9.getMessage()).toString());
    }

    private String to(Encoder encoder) throws CryptoException {
        try {
            DefaultEncryptHandler defaultEncryptHandler = this;
            defaultEncryptHandler.doEncrypt();
            return encoder.encode(defaultEncryptHandler.cipherText.getCipherBytes());
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to encode cipher bytes: ").append(codecException.getMessage()).toString());
        }
    }

    @Override
    public DefaultEncryptHandler from(byte[] byArray) throws CryptoException {
        DefaultEncryptHandler defaultEncryptHandler = this;
        defaultEncryptHandler.cipherText.setPlainBytes(ByteUtil.clone(byArray));
        return defaultEncryptHandler;
    }

    @Override
    public DefaultEncryptHandler from(String string) throws CryptoException {
        return this.from(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public DefaultEncryptHandler fromBase64(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64);
    }

    @Override
    public DefaultEncryptHandler fromBase64Url(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64URL);
    }

    @Override
    public DefaultEncryptHandler fromHex(String string) throws CryptoException {
        return this.from(string, Decoder.HEX);
    }

    @Override
    public byte[] to() throws CryptoException {
        DefaultEncryptHandler defaultEncryptHandler = this;
        defaultEncryptHandler.doEncrypt();
        return defaultEncryptHandler.cipherText.getCipherBytes();
    }

    @Override
    public String toBase64() throws CryptoException {
        return this.to(Encoder.BASE64);
    }

    @Override
    public String toBase64Url() throws CryptoException {
        return this.to(Encoder.BASE64URL);
    }

    @Override
    public String toHex() throws CryptoException {
        return this.to(Encoder.HEX);
    }
}

