/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.cipher.aes;

import android.os.Build;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherText;
import com.huawei.wisesecurity.kfs.crypto.cipher.DecryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.DefaultDecryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.DefaultEncryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.EncryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.util.ByteUtil;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public class AESCipher
implements KfsCipher {
    private final CipherAlg cipherAlg;
    private final KeyStoreProvider provider;
    private final Key key;
    private final AlgorithmParameterSpec parameterSpec;

    private AESCipher(KeyStoreProvider keyStoreProvider, CipherAlg cipherAlg, Key key, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.cipherAlg = cipherAlg;
        this.key = key;
        this.parameterSpec = algorithmParameterSpec;
    }

    public /* synthetic */ AESCipher(KeyStoreProvider keyStoreProvider, CipherAlg cipherAlg, Key key, AlgorithmParameterSpec algorithmParameterSpec, 1 var5_5) {
        this(keyStoreProvider, cipherAlg, key, algorithmParameterSpec);
    }

    @Override
    public EncryptHandler getEncryptHandler() throws CryptoException {
        CipherText cipherText;
        CipherText cipherText2 = cipherText;
        cipherText2();
        cipherText.setAlgId(object.cipherAlg);
        AESCipher aESCipher = object;
        Object object = aESCipher.provider;
        Key key = aESCipher.key;
        AlgorithmParameterSpec algorithmParameterSpec = aESCipher.parameterSpec;
        return new DefaultEncryptHandler((KeyStoreProvider)((Object)object), key, cipherText2, algorithmParameterSpec);
    }

    @Override
    public DecryptHandler getDecryptHandler() throws CryptoException {
        CipherText cipherText;
        CipherText cipherText2 = cipherText;
        cipherText2();
        cipherText.setAlgId(object.cipherAlg);
        AESCipher aESCipher = object;
        Object object = aESCipher.provider;
        Key key = aESCipher.key;
        AlgorithmParameterSpec algorithmParameterSpec = aESCipher.parameterSpec;
        return new DefaultDecryptHandler((KeyStoreProvider)((Object)object), key, cipherText2, algorithmParameterSpec);
    }

    public static class Builder {
        private CipherAlg cipherAlg = CipherAlg.getPreferredAlg("AES");
        private Key key;
        private AlgorithmParameterSpec parameterSpec;
        private final KeyStoreProvider keyStoreProvider;

        public Builder() {
            this.keyStoreProvider = KeyStoreProvider.ANDROID_KEYSTORE;
        }

        public Builder(KeyStoreProvider keyStoreProvider) {
            this.keyStoreProvider = keyStoreProvider;
        }

        public Builder withAlg(CipherAlg cipherAlg) {
            this.cipherAlg = cipherAlg;
            return this;
        }

        public Builder withKey(Key key) {
            this.key = key;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder withKeyStoreAlias(String string) throws KfsException {
            void var0_6;
            Builder builder = this;
            Builder builder2 = builder;
            Builder builder3 = builder;
            KeyStore keyStore = KeyStore.getInstance(builder.keyStoreProvider.getName());
            try {
                keyStore.load(null);
                builder3.key = keyStore.getKey(string, null);
                return builder2;
            }
            catch (IOException iOException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
            }
            catch (CertificateException certificateException) {
            }
            catch (KeyStoreException keyStoreException) {
                // empty catch block
            }
            throw new KfsException(e.a((Exception)var0_6, f.a("keystore get key with alias failed, ")));
        }

        public Builder withIv(byte[] byArray) throws CryptoException {
            int n2 = 1.$SwitchMap$com$huawei$wisesecurity$kfs$crypto$cipher$CipherAlg[this.cipherAlg.ordinal()];
            if (n2 != 1) {
                if (n2 != 2 && n2 != 3) {
                    throw new CryptoException("unsupported cipher alg");
                }
                this.parameterSpec = new IvParameterSpec(ByteUtil.clone(byArray));
            } else if (Build.VERSION.SDK_INT < 21) {
                IvParameterSpec ivParameterSpec;
                IvParameterSpec ivParameterSpec2 = ivParameterSpec;
                int n3 = byArray.length;
                ivParameterSpec = new IvParameterSpec(byArray, 0, n3);
                this.parameterSpec = ivParameterSpec2;
            } else {
                GCMParameterSpec gCMParameterSpec;
                GCMParameterSpec gCMParameterSpec2 = gCMParameterSpec;
                gCMParameterSpec = new GCMParameterSpec(128, ByteUtil.clone(byArray));
                this.parameterSpec = gCMParameterSpec2;
            }
            return this;
        }

        public AESCipher build() throws CryptoException {
            AlgorithmParameterSpec algorithmParameterSpec;
            Key key = object.key;
            if (key != null && (algorithmParameterSpec = object.parameterSpec) != null) {
                Builder builder = object;
                Object object = builder.keyStoreProvider;
                return new AESCipher((KeyStoreProvider)((Object)object), builder.cipherAlg, key, algorithmParameterSpec, null);
            }
            throw new CryptoException("key | parameterSpec cannot be null");
        }
    }
}

