/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.cipher.rsa;

import com.huawei.wisesecurity.kfs.crypto.AsymmetricBuilder;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherText;
import com.huawei.wisesecurity.kfs.crypto.cipher.DecryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.DefaultDecryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.DefaultEncryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.EncryptHandler;
import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public class RSACipher
implements KfsCipher {
    private final CipherAlg cipherAlg;
    private final KeyStoreProvider provider;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final AlgorithmParameterSpec parameterSpec;

    private RSACipher(KeyStoreProvider keyStoreProvider, CipherAlg cipherAlg, PrivateKey privateKey, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec) {
        this.provider = keyStoreProvider;
        this.cipherAlg = cipherAlg;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.parameterSpec = algorithmParameterSpec;
    }

    public /* synthetic */ RSACipher(KeyStoreProvider keyStoreProvider, CipherAlg cipherAlg, PrivateKey privateKey, PublicKey publicKey, AlgorithmParameterSpec algorithmParameterSpec, 1 var6_6) {
        this(keyStoreProvider, cipherAlg, privateKey, publicKey, algorithmParameterSpec);
    }

    @Override
    public EncryptHandler getEncryptHandler() throws CryptoException {
        CipherText cipherText;
        CipherText cipherText2 = cipherText;
        cipherText2();
        cipherText.setAlgId(object.cipherAlg);
        PublicKey publicKey = object.publicKey;
        if (publicKey != null) {
            RSACipher rSACipher = object;
            Object object = rSACipher.provider;
            AlgorithmParameterSpec algorithmParameterSpec = rSACipher.parameterSpec;
            return new DefaultEncryptHandler((KeyStoreProvider)((Object)object), publicKey, cipherText2, algorithmParameterSpec);
        }
        throw new CryptoException("publicKey is invalid.");
    }

    @Override
    public DecryptHandler getDecryptHandler() throws CryptoException {
        CipherText cipherText;
        CipherText cipherText2 = cipherText;
        cipherText2();
        cipherText.setAlgId(object.cipherAlg);
        PrivateKey privateKey = object.privateKey;
        if (privateKey != null) {
            RSACipher rSACipher = object;
            Object object = rSACipher.provider;
            AlgorithmParameterSpec algorithmParameterSpec = rSACipher.parameterSpec;
            return new DefaultDecryptHandler((KeyStoreProvider)((Object)object), privateKey, cipherText2, algorithmParameterSpec);
        }
        throw new CryptoException("privateKey is invalid.");
    }

    public static class Builder
    extends AsymmetricBuilder<RSACipher> {
        private CipherAlg cipherAlg = CipherAlg.getPreferredAlg("RSA");
        private final AlgorithmParameterSpec parameterSpec;

        public Builder() {
            super(KeyStoreProvider.ANDROID_KEYSTORE);
            MGF1ParameterSpec mGF1ParameterSpec = MGF1ParameterSpec.SHA1;
            PSource.PSpecified pSpecified = PSource.PSpecified.DEFAULT;
            v0.parameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", mGF1ParameterSpec, pSpecified);
        }

        public Builder(KeyStoreProvider object) {
            super((KeyStoreProvider)((Object)object));
            MGF1ParameterSpec mGF1ParameterSpec = MGF1ParameterSpec.SHA1;
            object = PSource.PSpecified.DEFAULT;
            v0.parameterSpec = new OAEPParameterSpec("SHA-256", "MGF1", mGF1ParameterSpec, (PSource)object);
        }

        public Builder withAlg(CipherAlg cipherAlg) {
            this.cipherAlg = cipherAlg;
            return this;
        }

        @Override
        public RSACipher build() throws CryptoException {
            Builder builder = object;
            Object object = builder.keyStoreProvider;
            CipherAlg cipherAlg = builder.cipherAlg;
            PrivateKey privateKey = builder.privateKey;
            PublicKey publicKey = builder.publicKey;
            AlgorithmParameterSpec algorithmParameterSpec = builder.parameterSpec;
            return new RSACipher((KeyStoreProvider)((Object)object), cipherAlg, privateKey, publicKey, algorithmParameterSpec, null);
        }
    }
}

