/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.codec;

import android.util.Base64;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.util.HexUtil;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;

public interface Decoder {
    public static final Decoder BASE64 = new Decoder(){

        @Override
        public byte[] decode(String string) throws CodecException {
            try {
                return Base64.decode((String)string, (int)0);
            }
            catch (Exception exception) {
                throw new CodecException(e.a(exception, f.a("Base64 decode fail : ")));
            }
        }
    };
    public static final Decoder BASE64URL = new Decoder(){

        @Override
        public byte[] decode(String string) throws CodecException {
            try {
                return Base64.decode((String)string, (int)8);
            }
            catch (Exception exception) {
                throw new CodecException(e.a(exception, f.a("Base64 decode fail : ")));
            }
        }
    };
    public static final Decoder HEX = new Decoder(){

        @Override
        public byte[] decode(String string) throws CodecException {
            return HexUtil.decodeHexString(string);
        }
    };
    public static final Decoder RAW_BYTES = new Decoder(){

        @Override
        public byte[] decode(String string) throws CodecException {
            return string.getBytes(StandardCharsets.UTF_8);
        }
    };

    public byte[] decode(String var1) throws CodecException;
}

