/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.codec;

import android.util.Base64;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.util.HexUtil;
import java.nio.charset.StandardCharsets;

public interface Encoder {
    public static final Encoder BASE64 = new Encoder(){

        @Override
        public String encode(byte[] byArray) throws CodecException {
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
    };
    public static final Encoder BASE64URL = new Encoder(){

        @Override
        public String encode(byte[] byArray) throws CodecException {
            return Base64.encodeToString((byte[])byArray, (int)10);
        }
    };
    public static final Encoder HEX = new Encoder(){

        @Override
        public String encode(byte[] byArray) throws CodecException {
            if (byArray == null) {
                return null;
            }
            return HexUtil.encodeHexString(byArray, false);
        }
    };
    public static final Encoder RAW = new Encoder(){

        @Override
        public String encode(byte[] byArray) throws CodecException {
            return new String(byArray, StandardCharsets.UTF_8);
        }
    };

    public String encode(byte[] var1) throws CodecException;
}

