/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.digest;

import com.huawei.wisesecurity.kfs.crypto.codec.Decoder;
import com.huawei.wisesecurity.kfs.crypto.codec.Encoder;
import com.huawei.wisesecurity.kfs.crypto.digest.DigestAlg;
import com.huawei.wisesecurity.kfs.crypto.digest.DigestHandler;
import com.huawei.wisesecurity.kfs.exception.CodecException;
import com.huawei.wisesecurity.kfs.exception.CryptoException;
import com.huawei.wisesecurity.kfs.util.ByteUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DefaultDigestHandler
implements DigestHandler {
    private final DigestAlg digestAlg;
    private byte[] data;

    public DefaultDigestHandler(DigestAlg digestAlg) {
        this.digestAlg = digestAlg;
    }

    private DigestHandler from(String string, Decoder decoder) throws CryptoException {
        DefaultDigestHandler defaultDigestHandler;
        try {
            DefaultDigestHandler defaultDigestHandler2 = this;
            defaultDigestHandler = defaultDigestHandler2;
            defaultDigestHandler2.from(decoder.decode(string));
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to decode plain text : ").append(codecException.getMessage()).toString());
        }
        return defaultDigestHandler;
    }

    private String digest(Encoder encoder) throws CryptoException {
        try {
            return encoder.encode(this.digest());
        }
        catch (CodecException codecException) {
            throw new CryptoException(f.a("Fail to encode signature bytes: ").append(codecException.getMessage()).toString());
        }
    }

    @Override
    public DigestHandler from(byte[] byArray) throws CryptoException {
        this.data = ByteUtil.clone(byArray);
        return this;
    }

    @Override
    public DigestHandler from(String string) throws CryptoException {
        return this.from(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public DigestHandler fromBase64(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64);
    }

    @Override
    public DigestHandler fromBase64Url(String string) throws CryptoException {
        return this.from(string, Decoder.BASE64URL);
    }

    @Override
    public DigestHandler fromHex(String string) throws CryptoException {
        return this.from(string, Decoder.HEX);
    }

    @Override
    public byte[] digest() throws CryptoException {
        try {
            return MessageDigest.getInstance(this.digestAlg.getTransformation()).digest(this.data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CryptoException(f.a("MessageDigest error : ").append(noSuchAlgorithmException.getMessage()).toString());
        }
    }

    @Override
    public String digestBase64() throws CryptoException {
        return this.digest(Encoder.BASE64);
    }

    @Override
    public String digestBase64Url() throws CryptoException {
        return this.digest(Encoder.BASE64URL);
    }

    @Override
    public String digestHex() throws CryptoException {
        return this.digest(Encoder.HEX);
    }
}

