/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import android.annotation.SuppressLint;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.aes.AESCipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyGenerateParam;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreKeyManager;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyPurpose;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.util.RandomUtil;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;

public class AESKeyStoreKeyManager
extends KeyStoreKeyManager {
    public AESKeyStoreKeyManager() {
    }

    public AESKeyStoreKeyManager(KeyStoreProvider keyStoreProvider) {
        super(keyStoreProvider);
    }

    private boolean isValidAesKeyLen(int n2) {
        return n2 != 128 && n2 != 192 && n2 != 256;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=24)
    public void generateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        void var0_4;
        block10: {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", this.getProvider().getProviderName());
            KeyGenerator keyGenerator2 = keyGenerator;
            KeyGenerator keyGenerator3 = keyGenerator;
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyGenerateParam.getAlias(), keyGenerateParam.getPurpose().getValue()).setKeySize(keyGenerateParam.getKeyLen()).setAttestationChallenge(this.getProvider().getName().getBytes(StandardCharsets.UTF_8)).setRandomizedEncryptionRequired(false);
            String[] stringArray = new String[2];
            stringArray[0] = "GCM";
            stringArray[1] = "CBC";
            KeyGenParameterSpec.Builder builder2 = builder.setBlockModes(stringArray);
            String[] stringArray2 = new String[2];
            stringArray2[0] = "NoPadding";
            stringArray2[1] = "PKCS7Padding";
            keyGenerator2.init((AlgorithmParameterSpec)builder2.setEncryptionPaddings(stringArray2).build());
            if (keyGenerator3.generateKey() == null) break block10;
            return;
        }
        try {
            throw new KfsException("generate aes key failed with bad key");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new KfsException(f.a("generate aes key failed, ").append(var0_4.getMessage()).toString());
    }

    @Override
    public void validateParam(KeyGenerateParam keyGenerateParam) throws KfsValidationException {
        if (!this.isValidAesKeyLen(keyGenerateParam.getKeyLen())) {
            if (keyGenerateParam.getPurpose() == KfsKeyPurpose.PURPOSE_CRYPTO) {
                return;
            }
            throw new KfsValidationException("bad purpose for aes key, only crypto is supported");
        }
        throw new KfsValidationException("bad aes key len");
    }

    @Override
    public void validateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        CipherAlg cipherAlg = CipherAlg.AES_GCM;
        this.validateCrypto(new AESCipher.Builder(this.getProvider()).withAlg(cipherAlg).withKeyStoreAlias(keyGenerateParam.getAlias()).withIv(RandomUtil.generateRandomBytes(cipherAlg.getIvLen())).build());
    }
}

