/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import android.annotation.SuppressLint;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.huawei.wisesecurity.kfs.crypto.key.KeyGenerateParam;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreKeyManager;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyPurpose;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.ec.ECSigner;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;

public class ECKeyStoreKeyManager
extends KeyStoreKeyManager {
    private static final AlgorithmParameterSpec EC_PRIME256_PARAMETER_SPEC = new ECGenParameterSpec("secp256r1");

    public ECKeyStoreKeyManager() {
    }

    public ECKeyStoreKeyManager(KeyStoreProvider keyStoreProvider) {
        super(keyStoreProvider);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=24)
    public void generateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        void var0_5;
        block15: {
            KeyGenParameterSpec.Builder builder;
            KeyPairGenerator keyPairGenerator;
            block14: {
                Object object;
                block13: {
                    KeyGenParameterSpec.Builder builder2;
                    KeyGenerateParam keyGenerateParam2 = keyGenerateParam;
                    keyPairGenerator = KeyPairGenerator.getInstance("EC", ((KeyStoreKeyManager)object).getProvider().getProviderName());
                    builder = builder2;
                    builder2 = new KeyGenParameterSpec.Builder(keyGenerateParam.getAlias(), keyGenerateParam.getPurpose().getValue());
                    if (!keyGenerateParam2.isAttestationChallengeEnable()) break block13;
                    object = ((KeyStoreKeyManager)object).getProvider().getName().getBytes(StandardCharsets.UTF_8);
                    break block14;
                }
                object = null;
            }
            KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
            KeyPairGenerator keyPairGenerator3 = keyPairGenerator2;
            KeyPairGenerator keyPairGenerator4 = keyPairGenerator2;
            KeyGenParameterSpec.Builder builder3 = builder.setAttestationChallenge((byte[])object);
            String[] stringArray = new String[3];
            stringArray[0] = "SHA-256";
            stringArray[1] = "SHA-384";
            stringArray[2] = "SHA-512";
            keyPairGenerator3.initialize((AlgorithmParameterSpec)builder3.setDigests(stringArray).setAlgorithmParameterSpec(EC_PRIME256_PARAMETER_SPEC).setKeySize(keyGenerateParam.getKeyLen()).build());
            if (keyPairGenerator4.generateKeyPair() == null) break block15;
            return;
        }
        try {
            throw new KfsException("generate ec key pair failed with bad key");
        }
        catch (ProviderException providerException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new KfsException(e.a((Exception)var0_5, f.a("generate ec key pair failed, ")));
    }

    @Override
    public void validateParam(KeyGenerateParam keyGenerateParam) throws KfsValidationException {
        if (keyGenerateParam.getKeyLen() == 256) {
            if (keyGenerateParam.getPurpose() == KfsKeyPurpose.PURPOSE_SIGN) {
                return;
            }
            throw new KfsValidationException("bad purpose for ec key, only sign is supported");
        }
        throw new KfsValidationException("bad ec key len, only ec prime 256 is supported");
    }

    @Override
    public void validateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        this.validateSign((KfsSigner)new ECSigner.Builder(this.getProvider()).withAlg(SignAlg.ECDSA).withKeyStoreAlias(keyGenerateParam.getAlias()).build());
    }
}

