/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import android.annotation.SuppressLint;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.huawei.wisesecurity.kfs.crypto.key.KeyGenerateParam;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreKeyManager;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyPurpose;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.hmac.HmacSigner;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.exception.KfsKeyStoreException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;

public class HmacKeyStoreKeyManager
extends KeyStoreKeyManager {
    public HmacKeyStoreKeyManager() {
    }

    public HmacKeyStoreKeyManager(KeyStoreProvider keyStoreProvider) {
        super(keyStoreProvider);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=23)
    public void generateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        void var0_4;
        block6: {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("HmacSHA256", this.getProvider().getProviderName());
            KeyGenerator keyGenerator2 = keyGenerator;
            KeyGenerator keyGenerator3 = keyGenerator;
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyGenerateParam.getAlias(), keyGenerateParam.getPurpose().getValue());
            String[] stringArray = new String[1];
            stringArray[0] = "SHA-256";
            keyGenerator2.init((AlgorithmParameterSpec)builder.setDigests(stringArray).setKeySize(keyGenerateParam.getKeyLen()).build());
            if (keyGenerator3.generateKey() == null) break block6;
            return;
        }
        try {
            throw new KfsException("generate hmac failed with bad key");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new KfsKeyStoreException(f.a("generate hmac key failed, ").append(var0_4.getMessage()).toString());
    }

    @Override
    public void validateParam(KeyGenerateParam keyGenerateParam) throws KfsValidationException {
        if (keyGenerateParam.getPurpose() == KfsKeyPurpose.PURPOSE_SIGN) {
            return;
        }
        throw new KfsValidationException("bad purpose for hmac key, only sign is supported");
    }

    @Override
    public void validateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        this.validateSign(new HmacSigner.Builder(this.getProvider()).withAlg(SignAlg.HMAC_SHA256).withKeyStoreAlias(keyGenerateParam.getAlias()).build());
    }
}

