/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyPurpose;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsNotBlank;
import com.huawei.wisesecurity.kfs.validation.constrains.KfsNotNull;

public class KeyGenerateParam {
    @KfsNotNull
    @KfsNotBlank
    private String alias;
    private int keyLen;
    @KfsNotNull
    private KfsKeyPurpose purpose;
    private boolean attestationChallengeEnable;

    public KeyGenerateParam(String string, int n2, KfsKeyPurpose kfsKeyPurpose) {
        this(string, n2, kfsKeyPurpose, true);
    }

    public KeyGenerateParam(String string, int n2, KfsKeyPurpose kfsKeyPurpose, boolean bl) {
        this.alias = string;
        this.keyLen = n2;
        this.purpose = kfsKeyPurpose;
        this.attestationChallengeEnable = bl;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public int getKeyLen() {
        return this.keyLen;
    }

    public void setKeyLen(int n2) {
        this.keyLen = n2;
    }

    public KfsKeyPurpose getPurpose() {
        return this.purpose;
    }

    public boolean isAttestationChallengeEnable() {
        return this.attestationChallengeEnable;
    }

    public void setPurpose(KfsKeyPurpose kfsKeyPurpose) {
        this.purpose = kfsKeyPurpose;
    }

    public static class Builder {
        private String alias;
        private int keyLen;
        private KfsKeyPurpose purpose;
        private boolean attestationChallengeEnable = true;

        public Builder alias(String string) {
            this.alias = string;
            return this;
        }

        public Builder keyLen(int n2) {
            this.keyLen = n2;
            return this;
        }

        public Builder purpose(KfsKeyPurpose kfsKeyPurpose) {
            this.purpose = kfsKeyPurpose;
            return this;
        }

        public Builder attestationChallengeEnable(boolean bl) {
            this.attestationChallengeEnable = bl;
            return this;
        }

        public KeyGenerateParam build() {
            Builder builder = string;
            String string = builder.alias;
            int n2 = builder.keyLen;
            KfsKeyPurpose kfsKeyPurpose = builder.purpose;
            boolean bl = builder.attestationChallengeEnable;
            return new KeyGenerateParam(string, n2, kfsKeyPurpose, bl);
        }
    }
}

