/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import android.util.Log;
import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyGenerateParam;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyManager;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.exception.KfsKeyStoreException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.kfs.util.HuksUtil;
import com.huawei.wisesecurity.kfs.util.RandomUtil;
import com.huawei.wisesecurity.kfs.validation.KfsValidator;
import com.huawei.wisesecurity.ucs_credential.e;
import com.huawei.wisesecurity.ucs_credential.f;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;

public abstract class KeyStoreKeyManager
implements KfsKeyManager {
    private static final String TAG = "KeyStoreKeyManager";
    private KeyStore mKeyStore;
    private final KeyStoreProvider provider;

    public KeyStoreKeyManager(KeyStoreProvider keyStoreProvider) {
        this.provider = keyStoreProvider;
    }

    public KeyStoreKeyManager() {
        this(KeyStoreProvider.ANDROID_KEYSTORE);
    }

    private void clearKey(String string) throws KfsException {
        if (this.hasAlias(string)) {
            try {
                this.mKeyStore.deleteEntry(string);
                Log.i((String)TAG, (String)("keyEntry: " + string + " removed"));
            }
            catch (KeyStoreException keyStoreException) {
                throw new KfsException(f.a("delete key entry failed, ").append(keyStoreException.getMessage()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initKeyStore() throws KfsException {
        void var0_5;
        if (this.mKeyStore != null) {
            return;
        }
        if (this.getProvider() == KeyStoreProvider.HUAWEI_KEYSTORE) {
            HuksUtil.getInstance();
        }
        KeyStore keyStore = KeyStore.getInstance(this.provider.getName());
        try {
            this.mKeyStore = keyStore;
            keyStore.load(null);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        throw new KfsException(e.a((Exception)var0_5, f.a("init keystore failed, ")));
    }

    @Override
    public void generate(KeyGenerateParam keyGenerateParam) throws KfsException {
        KeyStoreKeyManager keyStoreKeyManager = this;
        KfsValidator.validate(keyGenerateParam);
        keyStoreKeyManager.validateParam(keyGenerateParam);
        keyStoreKeyManager.generateKey(keyGenerateParam);
        try {
            keyStoreKeyManager.validateKey(keyGenerateParam);
            return;
        }
        catch (KfsException kfsException) {
            Log.i((String)TAG, (String)f.a("validate key failed, try to remove the key entry for alias:").append(keyGenerateParam.getAlias()).toString());
            this.clearKey(keyGenerateParam.getAlias());
            throw kfsException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Key getKey(String string) throws KfsException {
        void var0_4;
        KeyStoreKeyManager keyStoreKeyManager = this;
        keyStoreKeyManager.initKeyStore();
        try {
            return keyStoreKeyManager.mKeyStore.getKey(string, null);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        throw new KfsException(f.a("keystore get key failed, ").append(var0_4.getMessage()).toString());
    }

    @Override
    public boolean hasAlias(String string) throws KfsException {
        KeyStoreKeyManager keyStoreKeyManager = this;
        keyStoreKeyManager.initKeyStore();
        try {
            return keyStoreKeyManager.mKeyStore.containsAlias(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KfsException(f.a("keystore check alias failed, ").append(keyStoreException.getMessage()).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PrivateKey getPrivateKey(String string) throws KfsException {
        void var0_4;
        KeyStoreKeyManager keyStoreKeyManager = this;
        keyStoreKeyManager.initKeyStore();
        try {
            return (PrivateKey)keyStoreKeyManager.mKeyStore.getKey(string, null);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        throw new KfsException(f.a("keystore get private key failed, ").append(var0_4.getMessage()).toString());
    }

    @Override
    public PublicKey getPublicKey(String string) throws KfsException {
        KeyStoreKeyManager keyStoreKeyManager = this;
        keyStoreKeyManager.initKeyStore();
        try {
            return keyStoreKeyManager.mKeyStore.getCertificate(string).getPublicKey();
        }
        catch (KeyStoreException keyStoreException) {
            throw new KfsException(f.a("keystore get public key failed, ").append(keyStoreException.getMessage()).toString());
        }
    }

    @Override
    public Certificate[] getCertificateChain(String string) throws KfsException {
        KeyStoreKeyManager keyStoreKeyManager = this;
        keyStoreKeyManager.initKeyStore();
        try {
            return keyStoreKeyManager.mKeyStore.getCertificateChain(string);
        }
        catch (KeyStoreException keyStoreException) {
            throw new KfsException(f.a("keystore get certificate chain failed, ").append(keyStoreException.getMessage()).toString());
        }
    }

    public void validateSign(KfsSigner object) throws KfsException {
        KfsSigner kfsSigner = object;
        Object object2 = RandomUtil.generateRandomBytes(32);
        object = kfsSigner.getSignHandler().from((byte[])object2).sign();
        if (kfsSigner.getVerifyHandler().fromData((byte[])object2).verify((byte[])object)) {
            return;
        }
        throw new KfsKeyStoreException("validate sign key get bad result");
    }

    public void validateCrypto(KfsCipher kfsCipher) throws KfsException {
        byte[] byArray = RandomUtil.generateRandomBytes(32);
        Object object = byArray;
        KfsCipher kfsCipher2 = kfsCipher;
        object = kfsCipher2.getEncryptHandler().from((byte[])object).to();
        if (Arrays.equals(byArray, kfsCipher2.getDecryptHandler().from((byte[])object).to())) {
            return;
        }
        throw new KfsKeyStoreException("validate crypto key get bad result");
    }

    public KeyStoreProvider getProvider() {
        return this.provider;
    }

    public abstract void generateKey(KeyGenerateParam var1) throws KfsException;

    public abstract void validateKey(KeyGenerateParam var1) throws KfsException;

    public abstract void validateParam(KeyGenerateParam var1) throws KfsValidationException;
}

