/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wisesecurity.kfs.crypto.key;

import android.annotation.SuppressLint;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.huawei.wisesecurity.kfs.crypto.cipher.CipherAlg;
import com.huawei.wisesecurity.kfs.crypto.cipher.KfsCipher;
import com.huawei.wisesecurity.kfs.crypto.cipher.rsa.RSACipher;
import com.huawei.wisesecurity.kfs.crypto.key.KeyGenerateParam;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreKeyManager;
import com.huawei.wisesecurity.kfs.crypto.key.KeyStoreProvider;
import com.huawei.wisesecurity.kfs.crypto.key.KfsKeyPurpose;
import com.huawei.wisesecurity.kfs.crypto.signer.KfsSigner;
import com.huawei.wisesecurity.kfs.crypto.signer.SignAlg;
import com.huawei.wisesecurity.kfs.crypto.signer.rsa.RSASigner;
import com.huawei.wisesecurity.kfs.exception.KfsException;
import com.huawei.wisesecurity.kfs.exception.KfsValidationException;
import com.huawei.wisesecurity.ucs_credential.f;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;

public class RSAKeyStoreKeyManager
extends KeyStoreKeyManager {
    public RSAKeyStoreKeyManager() {
    }

    public RSAKeyStoreKeyManager(KeyStoreProvider keyStoreProvider) {
        super(keyStoreProvider);
    }

    private boolean isValidRsaKeyLen(int n2) {
        return n2 != 2048 && n2 != 3072 && n2 != 4096;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SuppressLint(value={"WrongConstant"})
    @RequiresApi(api=24)
    public void generateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        void var0_4;
        block13: {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", this.getProvider().getProviderName());
            KeyPairGenerator keyPairGenerator2 = keyPairGenerator;
            KeyPairGenerator keyPairGenerator3 = keyPairGenerator;
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(keyGenerateParam.getAlias(), keyGenerateParam.getPurpose().getValue()).setAttestationChallenge(this.getProvider().getName().getBytes(StandardCharsets.UTF_8));
            String[] stringArray = new String[2];
            stringArray[0] = "PKCS1";
            stringArray[1] = "PSS";
            KeyGenParameterSpec.Builder builder2 = builder.setSignaturePaddings(stringArray);
            String[] stringArray2 = new String[2];
            stringArray2[0] = "PKCS1Padding";
            stringArray2[1] = "OAEPPadding";
            KeyGenParameterSpec.Builder builder3 = builder2.setEncryptionPaddings(stringArray2);
            String[] stringArray3 = new String[3];
            stringArray3[0] = "SHA-256";
            stringArray3[1] = "SHA-384";
            stringArray3[2] = "SHA-512";
            keyPairGenerator2.initialize((AlgorithmParameterSpec)builder3.setDigests(stringArray3).setKeySize(keyGenerateParam.getKeyLen()).build());
            if (keyPairGenerator3.generateKeyPair() == null) break block13;
            return;
        }
        try {
            throw new KfsException("generate rsa key pair failed with bad key");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        throw new KfsException(f.a("generate rsa key pair failed, ").append(var0_4.getMessage()).toString());
    }

    @Override
    public void validateParam(KeyGenerateParam keyGenerateParam) throws KfsValidationException {
        if (!this.isValidRsaKeyLen(keyGenerateParam.getKeyLen())) {
            return;
        }
        throw new KfsValidationException("bad rsa key len");
    }

    @Override
    public void validateKey(KeyGenerateParam keyGenerateParam) throws KfsException {
        if (KfsKeyPurpose.containsPurpose(keyGenerateParam.getPurpose(), KfsKeyPurpose.PURPOSE_CRYPTO)) {
            this.validateCrypto((KfsCipher)new RSACipher.Builder(this.getProvider()).withAlg(CipherAlg.RSA_OAEP).withKeyStoreAlias(keyGenerateParam.getAlias()).build());
        }
        if (KfsKeyPurpose.containsPurpose(keyGenerateParam.getPurpose(), KfsKeyPurpose.PURPOSE_SIGN)) {
            this.validateSign((KfsSigner)new RSASigner.Builder(this.getProvider()).withAlg(SignAlg.RSA_SHA256).withKeyStoreAlias(keyGenerateParam.getAlias()).build());
        }
    }
}

